
clear all; close all; clc;

global modelOptions;
modelOptions.experiment = 0;
modelOptions.FiscalAdj = 4;
modelOptions.search = false;
modelOptions.stickyPrices = true;
modelOptions.robustness = 6

if ~modelOptions.search
    run('FullModel/parameters/initparams');
else
    run('FullModel/parameters/initparams_search');
end
    
if modelOptions.experiment > 0
    fname = ['FullModel/parameters/exper_' num2str(modelOptions.experiment)];
    run(fname);
    clear fname;
end

%modify the parameters as per the robustness exercise
modelOptions.GHH = false;
if modelOptions.robustness > 0
    fname = ['FullModel/parameters/robustness_' num2str(modelOptions.robustness)];
    run(fname);
    clear fname;
end

Params.warned = false;
Params.skill_orig = wage_grid;



[parstart, savePar] = guessHouseholdPolicyRules(false);



Params.parstart = parstart;

x_in = [Params.betah;Params.skille/Params.wage_scale_parameter; Params.wage_scale_parameter; Params.psi1;  Params.betae;  ...
    Params.TuSkillWeight; max(Params.To); Params.GonY; Params.debt2GDP;Params.tauC; ...
     Params.tauP;  Params.fixedCost(1);  Params.upsilon];
 
if modelOptions.search
    x_in = [x_in; Params.LF.ss.USearchEff;Params.LF.ss.NSearchEff];
end


    

%switch here to do Broyden or just test the given parameters
doBroyden = true;
if doBroyden

  
    optset('broyden','tol',1e-5);   
    optset('broyden', 'maxit', 15);

    if exist([Params.dirpath '/initCond/calib_fji.mat'], 'file') 
        load([Params.dirpath '/initCond/calib_fji.mat']);
        [sz1, sz2] = size(fjacinv);
        if sz1 == length(x_in) && sz1 == length(x_in)
            optset('broyden','initb',fjacinv);    
        end
    end

    [x,fval,flag,it, fjacinv] = broyden(@calibrate_check_stst,x_in);

    save([Params.dirpath '/initCond/calib_fji.mat'], 'fjacinv');
    
else
    %test given parameters
    r = calibrate_check_stst(x_in), x = x_in;

end
    


Params.betah = x(1);
skille_relative = x(2);
%income scale  ParIn(3)
Params.skill = Params.skill_orig * x(3);
Params.skille = skille_relative*x(3);
Params.psi1 = x(4);


%EntIncomeRelativeToMean = Params.incomeshare*(1+Params.nu);
%xe_resid = compute_stst(EntIncomeRelativeToMean);
%assert(abs(xe_resid)<1e-3,'xe_resid is too large');

disp('Add the following to initparams.m:')
disp(['Params.betah = ' num2str(x(1),12)])
disp(['Params.psi1 = ' num2str(x(4),12)])
disp(['Params.skille = ' num2str(x(2)*x(3),12)]);
skill = Params.skill_orig * x(3);

disp(['wage_scale_parameter = ' num2str(x(3),12)]);






disp(['Params.betae = ' num2str(x(5),12)]);

disp(['Params.TuSkillWeight = ' num2str(x(6),12)]);
disp(['Params.To = ' num2str(x(7),12)]);

disp(['Params.GonY = ' num2str(x(8),12)]);
disp(['Params.debt2GDP = ' num2str(x(9),12)]);


disp(['Params.tauC = ' num2str(x(10),12)]);
disp(['Params.tauP = ' num2str(x(11),12)]);
disp(['Params.fixedCost(1) = ' num2str(x(12),12)]);
disp(['Params.upsilon = ' num2str(x(13),12)]);

if modelOptions.search
    disp(['Params.LF.ss.USearchEff = ' num2str(x(14),12)]);
    disp(['Params.LF.ss.NSearchEff = ' num2str(x(15),12)]);
end





%%%%%%  these are for RepAgent economy.
if Params.npp > 3
    disp(' ');
    disp('For RepAgent Economy:')

    skill_dist = Params.nu*invdistr(Params.wageTrans');
    sep = 1+1/Params.psi2;
    hhldskillweight = (dot(Params.skill(1:3).^sep,skill_dist)/Params.nu).^(1/sep);
    disp(['Params.smeanofhhlds = ' num2str(hhldskillweight,12) ';'])
end