function [resid,Env] = equ(X,Env)

global Params modelOptions;

ne = NaN;  %suppress a warning.

%unpack
xcurr = X(Env.varix.x);
xlag = X(Env.varix.xlag);
eta = X(Env.varix.eta);
eps = X(Env.varix.eps);

[D,par,dz,xagg,Env] = x2par(xcurr,Env); %#ok
[Dlag,parlag,dzlag,xagglag] = x2par(xlag,Env); %#ok


% unpack stst, xagg and xagglag into local namespace
for nm_i = 1:length(Params.aggnames)
    eval([Params.aggnames{nm_i} '_stst = Env.aggstst(nm_i);'])
    eval([Params.aggnames{nm_i} ' = xagg(nm_i);'])
    eval([Params.aggnames{nm_i} '_L = xagglag(nm_i);'])
end

ce  = ce*(Y - G - FixedCost((Y-Y_stst)/Y_stst) -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L);
Inv = Inv*(Y - G - FixedCost((Y-Y_stst)/Y_stst) -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L);

ce_L  = ce_L*(Y_L - G_L - FixedCost((Y_L-Y_stst)/Y_stst) -  Params.Psi/2 * ((K_L-Klag_L)/Klag_L).^2 * Klag_L);
Inv_L = Inv_L*(Y_L - G_L - FixedCost((Y_L-Y_stst)/Y_stst) -  Params.Psi/2 * ((K_L-Klag_L)/Klag_L).^2 * Klag_L);


nv = Params.nv*Params.npp;
nc = Params.nc*Params.npp;


%unpack expectational errors
if modelOptions.search
    eta_c_hhld = eta(1:nc);
    eta_v_hhld = eta(nc+1:nc+nv);
    nsearch = sum(~Params.employed)*Params.nn;
    eta_n_hhld = eta(nc+nv+1:nc+nv+nsearch);
    eta_agg = eta(nc+nv+nsearch+1:nc+nv+nsearch+Params.nAggEta);
else
    eta_c_hhld = eta(1:nc);
    eta_agg = eta(nc+1:nc+Params.nAggEta);
end





if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 2 || modelOptions.FiscalAdj == 6
    LumpSumTax = Params.LumpSumTax;
end
if modelOptions.FiscalAdj == 1  || modelOptions.FiscalAdj == 2 || modelOptions.FiscalAdj == 5
    % in these cases there is a balanced budget so gov debt stays at steady
    % state
    B_stst = assetsh_stst + be_stst;
    B = B_stst;
    B_L = B_stst;
end
if modelOptions.FiscalAdj == 6
    tauK = Params.tauK + dtau;
    tauC = Params.tauC + dtau;
    tauP = Params.tauP + dtau;
    tauP_L = Params.tauP + dtau_L;
    tauC_L = Params.tauC + dtau_L;
    tauK_L = Params.tauK + dtau_L;
else
    tauK = Params.tauK;
    tauC = Params.tauC;
    tauP = Params.tauP;
    tauP_L = Params.tauP;
    tauC_L = Params.tauC;
    tauK_L = Params.tauK;
    dtau = 0;
    dtau_L = 0;
end

if ~modelOptions.stickyPrices
    M = 1/Params.mu;
    M_L = M;
    S = 1;
    ppi = 1;
end


%calculate wages and interest rates
wage =  M*(1-Params.alpha)*z* KL.^Params.alpha;
wage_L =  M_L*(1-Params.alpha)*z_L* KL_L.^Params.alpha;
rhat =  -Params.delta + M*Params.alpha*z* KL.^(Params.alpha-1);
r = (1-tauK)/(1-tauK*Params.upsilon) * rhat;

%Dividends
fixedCosts = FixedCost((Y-Y_stst)/Y_stst);
after_tax_div_intermed = (1-tauK)*(Y - M * z * K_L.^Params.alpha * N.^(1-Params.alpha) - fixedCosts);
revenue_from_corporate_inc_tax = tauK*(Y - M * z * K_L.^Params.alpha * N.^(1-Params.alpha) - fixedCosts) ...
    + tauK*(1-Params.upsilon)/(1-Params.upsilon*tauK)*rhat*K_L;

if modelOptions.robustness == 11
    %more cyclical corporate income tax revenue
    extraRev = tauK*Params.ExtraCorpIncomeTaxRevenue * ( Y - Y_stst)./Y_stst;
    revenue_from_corporate_inc_tax = revenue_from_corporate_inc_tax + extraRev;
    after_tax_div_intermed = after_tax_div_intermed - extraRev;
end

%for div_cap see below
dividend =  after_tax_div_intermed + div_cap - tauP*firmValue;



%entrepreneur's income tax rates
[margtaxe, taxpaide] = interp_tax(xe,Params.incometax,dtau);
margtaxe_L = interp_tax(xe_L,Params.incometax,dtau_L);
margtaxe_stst = interp_tax(xe_stst,Params.incometax);


%rescale household savings by inflation
Dlagscaled = scaleassets(Dlag,(1/ppi));




%household consumption
[ch, ~, taxpaidh] = expect_C(Dlagscaled,par,1+iitrack1,wage,[],taxshock+dtau);


if modelOptions.stickyPrices
    laborMarketStatus = Params.shockWeight(1) * log(z) - Params.shockWeight(2)*mpshock - (1-sum(Params.shockWeight))*markupshock;
    laborMarketStatus_L = Params.shockWeight(1) * log(z_L) - Params.shockWeight(2)*mpshock_L - (1-sum(Params.shockWeight))*markupshock_L;
else
    laborMarketStatus = Params.shockWeight * log(z);
    laborMarketStatus_L =  Params.shockWeight * log(z_L);
end






% The distribution over discrete states
discDistlag = initsize(zeros(Params.npp,1),X);
for ip = 1:Params.npp
    discDistlag(ip) = expect_1(Dlag,ip);
end

tmp = Params.Tu + Params.To;

transferspending = (Params.nu*discDistlag)' * tmp;


taxRevenue = Params.nu*taxpaidh + taxpaide + LumpSumTax ...
    + tauC*C + firmValue*tauP + revenue_from_corporate_inc_tax;




% ---- aggregate equations (order them with backward, then static then forward) ---

resAgg = initsize(zeros(Params.nagg,1),X);

equCount = 0;
resAgg(equCount+1) = log(z)-Params.rhoz*log(z_L)-eps(1);  %AR(1)
resAgg(equCount+2) = Gshock - Params.rhoG*Gshock_L -eps(2);
resAgg(equCount+3) = taxshock - Params.rhotax*taxshock_L -eps(3);
equCount = equCount + 3;

if modelOptions.stickyPrices
    resAgg(equCount+1) = -mpshock + Params.rhomp * mpshock_L + eps(4);
    resAgg(equCount+2) = -markupshock + Params.rhomarkup * markupshock_L + eps(5);
    equCount = equCount + 2;
end



resAgg(equCount+1) = be + assetsh - B; % asset market clearing
resAgg(equCount+2) = -B  + B_L*(1 + iitrack1)/ppi + G + transferspending - taxRevenue; %gov budg



resAgg(equCount+3) = KL - K_L/N;  % def of KL
resAgg(equCount+4) = Y*S - z * K_L.^Params.alpha * N.^(1-Params.alpha);
resAgg(equCount+5) = iitrack1 - ii_L;  %keep an extra lag of risk-free rate
resAgg(equCount+6) = assetsh - expect_k(D)*Params.nu;  % def of assetsh
resAgg(equCount+7) = nh - expect_L(Dlagscaled,par,true)*Params.nu; % def of nh
resAgg(equCount+8) = N - nh - ne*Params.skille;  %def of N

if modelOptions.GHH
    resAgg(equCount+9) = Params.psi1*ne.^(Params.psi2) - Params.skille*wage*(1-margtaxe)/(1+tauC); %entrepreneur labor supply
else
    resAgg(equCount+9) = Params.psi1*ne.^(Params.psi2) - ce.^(-Params.sigma).*Params.skille*wage*(1-margtaxe)/(1+tauC); %entrepreneur labor supply
end

resAgg(equCount+10) = Hrs - ne - expect_L(Dlagscaled,par,false)*Params.nu; % raw hours worked

resAgg(equCount+11) = -xe + be_L/ppi*iitrack1 + Params.skille*ne*wage + dividend;
resAgg(equCount+12) = ce + ch*Params.nu - C;
resAgg(equCount+13) = Klag - K_L;
resAgg(equCount+14) = -div_cap +  r *K_L - K + K_L - Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L;


%resAgg(equCount+15) = be + ce*(1+Params.tauC)  - be_L/ppi - (xe - taxpaide) + LumpSumTax;  % budget const
resAgg(equCount+15) = (K + C + G) - (Y + (1-Params.delta)*K_L - FixedCost((Y-Y_stst)/Y_stst) -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L);  %agg res con

% capital evolution
resAgg(equCount + 16) = -K + (1-Params.delta)*K_L+Inv;

resAgg(equCount + 17) = U - dot(1*(Params.estatus == 2),discDistlag);
resAgg(equCount + 18) = NLF - dot(1*(Params.estatus == 3),discDistlag);

resAgg(equCount + 19) = jobfind - expect_jobfind(Dlagscaled,par,laborMarketStatus);

resAgg(equCount + 20) = taxes_income - (Params.nu*taxpaidh + taxpaide);

resAgg(equCount + 21) = taxes_corp - revenue_from_corporate_inc_tax;

resAgg(equCount + 22) = taxes_prop - firmValue*tauP;

resAgg(equCount + 23) = ce_track - ce;

resAgg(equCount + 24) = UI - (Params.nu*discDistlag)' * Params.Tu;

resAgg(equCount + 25) = margtaxe_track - margtaxe;

resAgg(equCount + 26) = Inv_track - Inv;

resAgg(equCount + 27) = taxes - taxRevenue;

equCount = equCount + 27;

if modelOptions.stickyPrices
    
    %TAYLOR RULE
    if  modelOptions.robustness == 7 ||  modelOptions.robustness == 10  % after-tax Taylor rule
        resAgg(equCount+1) = -ii_L*(1-margtaxe) + (1-margtaxe_stst)*ii_stst + Params.phiP*(ppi_L-1) + Params.phiY*log(Y_L/Y_stst) +  mpshock +  eta_agg(6);
    elseif modelOptions.robustness == 3  % Schmitt-Grohe Uribe rule
        %1) add an output lag
        resAgg(equCount + 1) = YLag - Y_L;
        equCount = equCount + 1;
        resAgg(equCount+1) = -log(ii) + (0.999*log(ii_L) + 0.001*log(ii_stst)) + 0.77*log(iitrack1/iitrack1_L) + 0.75*log(ppi_L) + 0.02 * log(YLag/YLag_L);
    elseif modelOptions.robustness == 14  % Ad hoc output term
        %1) add an output lag
        resAgg(equCount + 1) = YLag - Y_L;
        equCount = equCount + 1;
        resAgg(equCount+1) = -ii_L*(1-margtaxe) + (1-margtaxe_stst)*ii_stst + Params.phiP*(ppi_L-1) + Params.phiY*log(Y_L/YLag_L) +  mpshock +  eta_agg(6);
    else
        % normal monetary policy rule
        resAgg(equCount+1) = -ii + ii_stst + Params.phiP*(ppi-1) + Params.phiY*log(Y/Y_stst) +  mpshock;
    end
    
    if modelOptions.robustness == 12  % flexible prices
        resAgg(equCount+2) = -pstar + 1;
    else
        resAgg(equCount+2) = -ppi + ((1-Params.theta)/(1-Params.theta*pstar.^(1/(1-Params.mu)))).^(1-Params.mu);  % pi
    end
    
    resAgg(equCount+3) = -pstar + pbarA/pbarB; %pstar
    
    resAgg(equCount+4) = -S + (1-Params.theta)*S_L*ppi.^(-Params.mu/(1-Params.mu))...
        +Params.theta*pstar.^(Params.mu/(1-Params.mu));  % price dispersion
    
    equCount = equCount + 4;
end



if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 1
    resAgg(equCount+1) = -G +  G_stst * (B_L/B_stst).^Params.phiLST + Gshock;  %fiscal policy rule
    equCount = equCount + 1;
elseif modelOptions.FiscalAdj == 3
    resAgg(equCount+1) = -G +  G_stst + Gshock;
    resAgg(equCount+2) = LumpSumTax - log((B_stst./B_L).^Params.phiLST) - LumpSumTax_stst;
    equCount = equCount +2;
elseif modelOptions.FiscalAdj == 4
    resAgg(equCount+1) = -log(G-Gshock) + log(G_stst) + (-Params.phiG/Params.phiLST) * (LumpSumTax - LumpSumTax_stst);
    resAgg(equCount + 2) = LumpSumTax - log((B_stst./B_L).^Params.phiLST) - LumpSumTax_stst;
    equCount = equCount + 2;
elseif modelOptions.FiscalAdj == 5
    resAgg(equCount+1) = -G +  G_stst + Gshock;
    equCount = equCount + 1;
    
elseif modelOptions.FiscalAdj == 6
    resAgg(equCount+1) =-log((G-Gshock)) + log(G_stst) + (-Params.phiG/Params.phiLST*Params.taxbase) * dtau;
    resAgg(equCount + 2) = dtau - log((B_stst./B_L).^(Params.phiLST/Params.taxbase));
    equCount = equCount + 2;
else
    assert(modelOptions.FiscalAdj == 2)
end

if modelOptions.GHH
    SDF = Params.betae * (ce - Params.psi1*ne.^(1+Params.psi2)./(1+Params.psi2) ).^(-Params.sigma) / (ce_L - Params.psi1*ne_L.^(1+Params.psi2)./(1+Params.psi2)).^(-Params.sigma) * (1+tauC_L)/(1+tauC);
else
    SDF = Params.betae * ce.^(-Params.sigma) / ce_L.^(-Params.sigma) * (1+tauC_L)/(1+tauC);
end


if modelOptions.experiment == 12 ||  modelOptions.experiment == 13
    taxRatio = 1;
else
    taxRatio = (1-margtaxe)/(1-margtaxe_L);
end



netI = Inv-Params.delta*K_L;
netI_L = Inv_L - Params.delta*Klag_L;

resAgg(equCount +1) =  -SDF*(1 + ii_L*(1-margtaxe))/ppi + 1 + eta_agg(1);  %Euler C

resAgg(equCount+2) = -taxRatio*SDF/(1+tauP)*(1 + r  - (Params.Psi/2)*(netI/K_L).^2 + Params.Psi*(netI/K_L)*(K/K_L))...
    + (1+Params.Psi*(netI_L/Klag_L)) + eta_agg(2); %euler K

resAgg(equCount+3) = -firmValue_L*(1 + tauP_L) + div_cap_L + taxRatio*SDF * firmValue + eta_agg(3);
equCount = equCount + 3;

if modelOptions.stickyPrices
    if modelOptions.robustness == 12
        resAgg(equCount+1) = -pbarB_L + Y_L; % pbarB
        resAgg(equCount+2) = -pbarA_L + M_L*Params.mu*Y_L + markupshock_L; % pbarA
    else
        resAgg(equCount+1) = -pbarB_L + Y_L*(1-tauK_L)/(1-Params.tauK) + taxRatio*SDF*(1-Params.theta)*ppi.^(-Params.mu/(1-Params.mu)-1)*pbarB +eta_agg(4); % pbarB
        resAgg(equCount+2) = -pbarA_L + M_L*Params.mu*Y_L*(1-tauK_L)/(1-Params.tauK) ...
            +taxRatio*SDF*(1-Params.theta)*ppi.^(-Params.mu/(1-Params.mu))*pbarA...
            +markupshock_L + eta_agg(5); % pbarA
    end
    equCount = equCount + 2;
end




% indexes

if modelOptions.stickyPrices
    aggBW = 1:7;
    aggStat = 8:equCount-5;
    aggFW = equCount-4:equCount;
else
    aggBW = 1:6;
    aggStat = 7:equCount-3;
    aggFW = equCount-2:equCount;
end




Pi = forwardmat(1,par,laborMarketStatus);
D2 = forward(Dlagscaled,Pi);
resD = distr2par(D2,Env) - distr2par(D,Env);

%Rtmp = -Params.delta + z*Params.alpha*KL.^(-1 + Params.alpha);
%Rtmp_L = -Params.delta + z*Params.alpha*KL_L.^(-1 + Params.alpha);
%resCn = eulerres(parlag,par,1+Rtmp_L,1+Rtmp,wage_L,wage);


resVNC = eulerres(parlag,par,1+iitrack1_L,1+iitrack1,wage_L,wage,...
    laborMarketStatus_L,ppi,taxshock_L,taxshock,dtau_L,dtau,false);

% add expectational errors
nemp = sum(Params.employed)*Params.nn;
if modelOptions.search
    resVNC = resVNC + [eta_v_hhld; zeros(nemp,1); eta_n_hhld; eta_c_hhld];
else
    resVNC = resVNC + [zeros(nemp,1); eta_c_hhld];
end





resid = [resD;
    resAgg;
    resVNC];



nbw = length(resD)+length(aggBW);
nstat = length(aggStat);
nfw = length(aggFW) + length(resVNC);

Env.iEquBW = 1:nbw;
Env.iEquStat = nbw + 1 : nbw + nstat;
Env.iEquFW = nbw + nstat + 1 : nbw + nstat + nfw;

Env.iEquBWS = [Env.iEquBW Env.iEquStat];
