
names = exact_soln.names;

simul = exact_soln.simaggdat';    


[tmpa tmpb] = size(simul);
assert(tmpa == modelOptions.sim_T);
assert(tmpb < 50);

clear tmpa tmpb;



%% select data


names_to_select = {'Y', 'ppi', 'U', 'NLF', 'Hrs', 'C', 'Inv_track'};


for i = 1:length(names_to_select)
    eval(['i' names_to_select{i} ' = find(strcmp(names,''' names_to_select{i} '''));']);
end

%% Transform data
simul(:,iY) = log(simul(:,iY));  % take log of Y
simul(:,iHrs) = log(simul(:,iHrs));  % take log of Hrs
simul(:,iC) = log(simul(:,iC));
simul(:,iInv_track) = log(simul(:,iInv_track));

%% Covariances and correlations
V0 = cov(simul);
stdeviation = sqrt(diag(V0));
if modelOptions.stickyPrices
    cov_logY_ppi = V0(iY,ippi);
    corr_logY_ppi = cov_logY_ppi/(stdeviation(iY)*stdeviation(ippi));
    std_ppi = stdeviation(ippi);
else
    corr_logY_ppi = [];
    std_ppi = [];
end

corr_logY_logC = V0(iY,iC)/(stdeviation(iY)*stdeviation(iC));

std_logy = stdeviation(iY);
std_logHrs = stdeviation(iHrs);
std_logI = stdeviation(iInv_track);

%% variance decomposition
doVarDecomp = modelOptions.experiment == 0 && modelOptions.FiscalAdj == 4 ...
    && modelOptions.stickyPrices == true && modelOptions.robustness == 0 && exist('G1','var');
if doVarDecomp
    
    vdecomp = zeros(1,5);
    for shock_i = [1 4 5]
        Sigma2 = zeros(5);
        Sigma2(shock_i,shock_i) = Params.Sigma(shock_i,shock_i);
        ser = simulateSystem(G1,impact,Hagg',10000,Sigma2);
        ser = ser +  Env.aggstst * ones(1,modelOptions.sim_T);
        vdecomp(shock_i) = var(ser(strcmp(Params.aggnames,'Y'),:));
    end
    vdecomp = vdecomp([1 4 5])/sum(vdecomp);
    modelmoments.var_decomp_of_Y.z = vdecomp(1);
    modelmoments.var_decomp_of_Y.mp = vdecomp(2);
    modelmoments.var_decomp_of_Y.markup = vdecomp(3);
    
end

%% Compute largest autoregressive root of inflation based on AR(3)

if modelOptions.stickyPrices
    m.a = ARq( simul(:,ippi), 3 );
    LARppi = max(abs(roots(m.a)));
else
    LARppi = [];
end


%%  variance of unemployment rate and food stamp ratio

U = simul(:,iU);
NLF = simul(:,iNLF);
E = 1 - U - NLF;

urate = Params.nu*U./(1+Params.nu*(U+E));
SNAP = Params.nu*NLF./(1+Params.nu*(U+E));

s_urate = std(urate);
s_SNAP = std(SNAP);


corr_u_Y = corrcoef([urate simul(:,iY)]);
corr_u_Y = corr_u_Y(1,2);


%% package results
modelmoments.std_logy = std_logy;
modelmoments.std_logHrs = std_logHrs;
modelmoments.std_ppi = std_ppi;
modelmoments.LARppi = LARppi;
modelmoments.corr_logY_ppi=corr_logY_ppi;
modelmoments.corr_u_Y = corr_u_Y;
modelmoments.std_urate =s_urate;
modelmoments.std_SNAP=s_SNAP;
modelmoments.corr_logY_logC = corr_logY_logC;
modelmoments.std_logI = std_logI;

if modelOptions.do_mpa

    MPA_soln.modelmoments = modelmoments;
    
else
    exact_soln.modelmoments = modelmoments;
    
end