function [c, n, margTax, taxpaid, taxableIncome] = get_cnt(x,savings,N,R,wage,incomeIndex,taxshock,dtau)
%compute consump, labor supply, and taxes
%inputs: 
% x assets (vector)
% savings (vector)
% N  labor spline or vector of labor supplies
% R, wage prices

if ~exist('taxshock','var')
    taxshock = 0;
end

    global Params;
    
    if ~exist('dtau','var')
        dtau = 0;
    end
    

    effectiveWage = Params.skill(incomeIndex)*wage;
    
    unemployed = ~all(Params.employed(incomeIndex));
    
    if isstruct(N)
        n = interp_nspline(N,x,true); %true -> take max of zero
    else
        n = max(N,0);
    end
    
    taxableIncome = (R-1)*x + effectiveWage*n + Params.Tu(incomeIndex);
    [margTax, taxpaid] = interp_tax(taxableIncome, Params.incometax,taxshock+dtau);
    c = (x + taxableIncome - taxpaid - savings + Params.To(incomeIndex))/(1+Params.tauC+dtau);
    