function [ parstart, needToSavePar] = guessHouseholdPolicyRules(doEGM)

%doEGM has several options:
% 0 (default) use stored initial conditions if available
% 1 iterate from naive guess
% 2 iterate from full model solution

%STARTING VALUES FOR_ CONSUMPTION FUNCTION AND LABOR SUPPLY:


global Params modelOptions;

if nargin < 1
    doEGM = 0;
end

experiment = modelOptions.experiment;
search = modelOptions.search;
robust = modelOptions.robustness;

file_id = ['_ex' num2str(experiment) '_se' num2str(search) '_rob' num2str(robust)];
file_id0 = ['_ex0_se' num2str(search) '_rob' num2str(robust)];

%make a reasonable guess of prices (err on side of low prices so that cons
%is not negative when we put the "real" prices in)

xe = Params.incomeshare*(1+Params.nu);
margtaxe = interp_tax(xe, Params.incometax);
[ ~, ~, wage, ii] = SteadyStatePrices( margtaxe );
    

if exist([Params.dirpath '/initCond/par' file_id '.mat'], 'file') && doEGM == 0
    load([Params.dirpath '/initCond/par' file_id '.mat']);
    parstart = par0;
    needToSavePar = false;
elseif exist([Params.dirpath '/initCond/par' file_id0 '.mat'], 'file') && doEGM ~= 1
    load([Params.dirpath '/initCond/par' file_id0 '.mat']);
    parstart = par0;
    if experiment ~= 0
        needToSavePar = true;
    else
        needToSavePar = false;
    end
else    

    needToSavePar = true;
    doEGM = true;
    
    %initial guess
    pars = [0; Params.knotXi]; %first element is sup {a :a'(a) = 0}
    parn = 0.31*ones(Params.nn,1);   
    parv = ones(Params.nv,1);
   
    par0 = [parv; parn; pars]; 
    par0 = repmat(par0,1,Params.npp);
            

end


if doEGM ~= 0
    
    if size(par0,2) == 1
        par0 = par2wide(par0);
    end
    
    %to get a good initial guess, use endog grid method but it does not need to
    %converge fully
    disp('Using endog. grid method to find a good initial guess for policy rules.');
    
    
    if modelOptions.search 
        error('Need to recode EGM for search')
    end
    parstart = egm_stst(par0,1+ii,wage,200); 
    
    parstart = par2long(parstart);
  
    
 end

end

