% Given c and n, this file computes du/dc.
% Created Jan 8, 2014 by AGM
function mu = margutilC_GHH(c,n)
  global Params;
  
  assert(all(c(:)>0),'c not positive');
  
  tmp = c - Params.psi1.*(n.^(1+Params.psi2))./(1+Params.psi2);
  
  if ~all(tmp(:)>0)
      [Params.psi1 Params.psi2]
      [c n Params.psi1.*(n.^(1+Params.psi2))./(1+Params.psi2) tmp]
  end
  
  assert(all(tmp(:)>0),'c-G(n) not positive');
  
  mu = tmp.^(-Params.sigma);
  
