function par = par2wide(par)

    

    global Params modelOptions;

    nn = Params.nn;
    nc = Params.nc;
    nv = Params.nv;
    npp = Params.npp;
    npp_n = Params.npp_n;
    
    [m n] = size(par);
    
    
        if m == nn+nc+nv && n == npp
            return
        end
    
    if modelOptions.search

        

        assert(m == (nn+nc+nv) * npp && n == 1);

        par = [reshape(par(1:npp*nv),nv,npp);  % vpar in wide form
               reshape(par(npp*nv+1:npp*(nv+nn)),nn,npp);  % npar in wide form
               reshape(par(npp*(nv+nn)+1:end),nc,npp)];  % cpar in wide form
    else
        
        
        if (m == nn*npp_n + (nc+nv) * npp && n == 1)

            par = [reshape(par(1:npp*nv),nv,npp);
                [reshape(par(npp*nv+1:npp*nv+nn*npp_n), nn, npp_n) zeros(nn, npp-npp_n)];
                    reshape(par(npp*nv+npp_n*nn+1:end),nc,npp)];
        
        elseif (m == nn*npp_n + nc*npp && n ==1)
            par = [NaN(nv,npp);
                [reshape(par(1:nn*npp_n), nn, npp_n) zeros(nn, npp-npp_n)];
                    reshape(par(npp_n*nn+1:end),nc,npp)];
        else
            error(['format of par supplied to par2wide is not recognized' num2str(m) ' ' num2str(n)])
        end
    end
