global Params;


[ret, name] = system('hostname');
if ret == 0 && strcmp(name(1:3),'scc')
    Params.dirpath = '~/autostab/FullModel';
    Params.saveResults = true;
    maxNumCompThreads(3); %don't use more than three computational threads
else
    Params.dirpath = '~/automatic_stabilization/autostab_repo/FullModel';
    Params.saveResults = false;
end


%% Scalars

Params.seed = 2.116921967000000e+05;

Params.freq = 4;

%preferences
Params.betah = 0.979681590435;  %household discount factor, see calibrate.m

Params.sigma = 1;     %risk aversion
Params.psi1 = 13.7537949248; % labor supply parameter
Params.psi2 = 2; % labor supply parameter
Params.betae = 0.988830128237;



%markets
Params.mu = 1.1;

Params.theta = 1/3.5;

%production
Params.fixedCost = [0.57528560756 0];
Params.alpha = 1 - (1-0.36) * Params.mu;  % capital share
Params.delta = 0.0456/4; % depreciation


%government
Params.debt2GDP = 1.69781919145;  % stst debt to GDP ratio
Params.tauC = 0.053544485989;
Params.tauP = 0.00258317982938;
Params.tauK = 0.35;  
Params.GonY = 0.145291631621;  
Params.upsilon = 0.679552793355;


%entrepreneur/hhld distribution
Params.nu = 4;
Params.skille = 2.6121468487; %see calibrate.m



%calibration targets used by calibrate.m:
%Params.incomeshare = 0.407;   %see Castaneda et al
%Params.assetshare = 0.714;   %see Castaneda et al
Params.incomeshare = 0.525;   %see Castaneda et al
Params.assetshare = 0.834;   %see Castaneda et al
Params.avgLaborSupplystst = 0.31;
Params.earningsshare = 0.48;






Params.SigmaEpsz = 0.002936169743355;  % st dev of z shock
Params.rhoz = 0.75; % persistence of z shock

Params.SigmaG = 0;
Params.rhoG = 0;

Params.Sigmatax = 0;
Params.rhotax = 0;

Params.SigmaEpsmp = 0.003533607840688; % st dev of MP shock
Params.rhomp = 0.62; % persistence


Params.Sigmamarkup =  0.025141071226995;
Params.rhomarkup = 0.85;

Params.phiLST =  -1.6;  % fiscal adjustment speed parameter
Params.phiG = 0.8*Params.phiLST;


Params.phiP = 1.55;
Params.phiY = 0.0;
Params.phii = 0.0;

Params.Psi =  6;   %capital adj cost

Params.shockWeight =  [ 0.639337048621449  0.317676504487140];  




if modelOptions.stickyPrices
    Params.Sigma = diag([Params.SigmaEpsz; Params.SigmaG; Params.Sigmatax; Params.SigmaEpsmp; Params.Sigmamarkup]);
else
    Params.Sigma = diag([Params.SigmaEpsz; Params.SigmaG; Params.Sigmatax]);
end



%% Household heterogeneity and income process

Params.npp = 9; %number of discrete household types.
                %you can use this to control "big" model with npp = 9
                %or small model (no skill differences) with npp = 3
                
Params.npp_n = Params.npp/3; %number of discrete household who work


if Params.npp == 3

     Params.skill = 1.0849; %wage grid
     Params.wageTrans = 1;

           
     nwage = 1;
     wage_grid = Params.skill;
     Params.wage_scale_parameter = 0.942079507225;
     
else
    
    Params.wage_scale_parameter =  0.0558178696591;
    
    % full wage process
    load wage_process;
    Params.skill = Params.wage_scale_parameter * wage_grid;
    Params.wageTrans = wage_trans;
    

   
   nwage = length(Params.skill);
   
   
   
   assert(length(Params.skill) == Params.npp/3,'Inconsistency between length of wage grid and Params.npp');
   
   
end

% It is crucial that skill = 0 for those not employed
Params.skill = [Params.skill; zeros(length(Params.skill)*2,1)]; 


Params.employed = logical([ones(1,nwage) zeros(1,nwage*2)]);  %note: make sure that this is organized as 1 1 1 1 0 0 0 0 
Params.estatus = kron(1:3,ones(1,nwage));
Params.sstatus = kron(ones(1,3),1:nwage);

%labor market transition probabilities
 Params.LFtransMat_ss = [   0.969425752923931   0.030574247076069                   0
   0.539801877892624   0.194832843834118   0.265365278273258
   0.087327000000000                   0   0.912673000000000];

% labor market fluctuations
Params.LFtransMat_z = [ 0   -2.812554072258800       0;
                        0  0    0;
                       2.325866859407174        0   0]; 


Params.LFtransMat_z = Params.LFtransMat_z + diag(zeros(3,1) - sum(Params.LFtransMat_z,2));
Params.LFtransMat_z_nonLinear = Params.LFtransMat_z./(max(Params.LFtransMat_ss,1e-10).*(1-Params.LFtransMat_ss));



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% set up ui and other benefits
Params.TuMaxBenefit = 0.66; %0.66 is 66% of average income
Params.TuSkillWeight = 0.139581241783;
Params.Tu = min(kron([0;1;0], Params.TuSkillWeight*Params.skill(Params.employed)),Params.TuMaxBenefit);  

Params.To = kron([0;0;0.150849142533], ones(Params.npp_n,1)); % other social benefits




%% Approximation of policy rules and asset positions

Params.nc = 100; %number of points in approximation of individual cons func
Params.nn = 100; %number of points in approximation of individual labor supply func
Params.nv = 100; %number of points in approximation of value function (only non-zero for search extentsion)
Params.ncnv = Params.nc + Params.nn + Params.nv;

%Params.ndstst = 1000; %number of points in wealth histogram
Params.ndstst = 250; %number of points in wealth histogram

Params.bhmin = 0;  %min bond position for household
Params.bhmax = 50;  %max bond position for household





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% quadrature grid for_ wealth distribution:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Params.nStatesDistr = Params.ndstst*Params.npp;  %makes only sense for npp==1; otherwise_:DSF!
% number knot points:
ndk = Params.ndstst ;
[Params.knotDistrK,Params.logshift] = makeknotd(Params.bhmin,Params.bhmax,ndk);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% KNOT POINTS FOR_ SAVINGS POLYNOMIAL:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Params.xmin = 0.001;
Params.xmax = 0.5*Params.bhmax; % beyond that point, linear extrapolation is fine!

 n1 = ceil(Params.nc/3);
 x1 = linspace(Params.xmin,0.2,n1+1)';
 x2 = logspaceshift(0.2,Params.xmax,Params.nc-n1,Params.logshift)';
 Params.knotXi = [x1(1:end-1);x2];

%  Params.knotXi = logspaceshift(Params.xmin,Params.xmax,Params.nc,Params.logshift)';


Params.knotXi = Params.knotXi(2:end);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% KNOT POINTS FOR_ LABOR SUPPLY POLYNOMIAL:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


Params.nxmin = 0.001;
Params.nxmax = Params.bhmax;
n1 = ceil(Params.nn/3);
x1 = linspace(Params.nxmin,0.2,n1+1)';
x2 = logspaceshift(0.2,Params.nxmax,Params.nn-n1,Params.logshift)';
Params.ngrid = [x1(1:end-1);x2];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% KNOT POINTS FOR_ VALUE FUNCTION POLYNOMIAL IN WELFARE EXPERIMENT:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Params.nv_welf = Params.nv;
% we define the value function as piece-wise linear in bhat = log(b+1)
Params.vxmin = log(1.001);
Params.vxmax = log(1+Params.bhmax); % beyond that point, log-linear extrapolation is fine!
Params.vgrid = linspace(Params.vxmin,Params.vxmax,Params.nv_welf)';


%% Income Tax Function

load incometax;
Params.incometax = incometax; clear incometax;

%Add a constant to tax function so that it generates aggregate income tax
%revenues.
taxConstant = -0.062;  % adjust intercept of income tax  
Params.incometax.marg(end) = Params.incometax.marg(end) + taxConstant;
Params.incometax.cumul(end-1) = Params.incometax.cumul(end-1) + taxConstant;
Params.incometax.breakval = Params.incometax.breakval + taxConstant;



%% Aggregate variables

if modelOptions.stickyPrices
    Params.nz = 5; % number of exogenous var

    % number of expectational errors in aggregate equations
    if modelOptions.robustness == 12
        Params.nAggEta = 3; % none in pbarA or pbarB equations
    elseif modelOptions.robustness == 7 || modelOptions.robustness == 10  %after-tax Taylor rule requires expectation of marginal tax rate.
        Params.nAggEta = 6;
    else %standard case
        Params.nAggEta = 5; 
    end
    
        
else
    Params.nz = 3;
    Params.nAggEta = 3;
end

exog = {'z', 'Gshock','taxshock', 'mpshock', 'markupshock'};
other_states = {'be', 'K'};
if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 3 || modelOptions.FiscalAdj == 4
    other_states = {other_states{:}, 'B'};
end


static = {'KL', 'Y', 'iitrack1', 'N', 'assetsh',  'G', 'nh', 'ne',...
    'xe', 'C', 'pstar', 'ppi', 'Klag', 'S', 'div_cap', 'M', 'Hrs', ...
    'U', 'NLF', 'jobfind', 'taxes_income', 'taxes_corp', 'taxes_prop',...
    'ce_track', 'Inv_track', 'UI','margtaxe_track','taxes'};
if modelOptions.FiscalAdj == 1 || modelOptions.FiscalAdj == 3 || modelOptions.FiscalAdj == 4 || modelOptions.FiscalAdj == 5
    static = {static{:}, 'LumpSumTax'};
end
if modelOptions.robustness == 3
    static = {static{:}, 'YLag'};
end
if modelOptions.stickyPrices
    static = {static{:}, 'ii'};
    dec = { 'ce', 'Inv',  'firmValue', 'pbarA', 'pbarB'};
else
    static = {static{:}, 'Inv'};
    dec = { 'ce', 'ii',  'firmValue'};
end
   



Params.aggnames = {exog{:}, other_states{:}, static{:}, dec{:}};

if ~modelOptions.stickyPrices
    %delete the following variables from the system
    delVar = {'S','M','pbarA','pbarB', 'pstar', 'ppi', 'mpshock', 'markupshock'};
   
    
    Params.aggnames = setdiffordered(Params.aggnames,delVar);
    dec = setdiffordered(dec,delVar);
    
end

Params.nagg = length(Params.aggnames);


% create indices
n = length(exog)+length(other_states);
Params.aggInd.state = logical([ones(1,n) zeros(1,Params.nagg-n)]);

n = length(dec);
Params.aggInd.dec = logical([zeros(1,Params.nagg-n) ones(1,n)]);

n = length(exog);
Params.aggInd.exog = logical([ones(1,n) zeros(1,Params.nagg-n)]);

Params.aggInd.static = ~logical(Params.aggInd.state + Params.aggInd.dec);


%% indexing

Params.par_sind = Params.nv+Params.nn+1:Params.nv+Params.nn+Params.nc;
Params.par_nind = Params.nv+1:Params.nv+Params.nn;
Params.par_vind = 1:Params.nv;