% plot_IRFs.m
% create a four panel plot of IRFs for the paper
% this is just done for the baseline economy.


close all; clear all; clc;
setpath('FullModel')

GHH = false;

T = 1:40;

vars = {'Y', 'C', 'Hrs',  'ppi','G','taxes'};


var_desc = {'Output', 'Consumption', 'Hours', 'Inflation', 'G', 'taxes'};

if ~GHH
    load FullModel/results/experiment_0_FiscalAdj_4_search_0_sticky_1_robustness_0.mat
else
    load FullModel/results/experiment_0_FiscalAdj_4_search_0_sticky_1_robustness_6.mat
end
I = strcmplist(exact_soln.names,vars);
if any(I ==0)
    error('variable not found')
end

irfn = size(exact_soln.irf_agg{1},1);
irfm = length(I);
nz = 5;
irf_all = zeros(irfn,irfm,nz);
for i = 1:nz
    irf_all(:,:,i) = exact_soln.irf_agg{i}(:,I);
end

stst = zeros(irfm, nz);
for kk = 1:nz
    stst(:,kk,1) = exact_soln.simul_avg(I);
end




fig1 = figure('Position',[1 1 600 660]);

for i = 1:4
    subplot(ceil(4/2),2,i);
    irf = squeeze(irf_all(:,i,:));
    irf = irf ./ (ones(length(irf),1) * squeeze(stst(i,:)));
    
    plot(T,irf(T,1),'LineWidth',2,'color','k');
    hold on;
    plot(T,-irf(T,4),'LineWidth',2,'color','k','LineStyle','--');
    plot(T,-irf(T,5),'LineWidth',1,'color','k','LineStyle','-','Marker','d','MarkerSize',2);
    hold off;
    
    title(var_desc{i});
    xlabel('Quarter','FontSize',14)
    
    if i == 1
        legend('Technology', 'Monetary','Markup');
    end
end




%% All multipliers in Full Model
T = 1:12;
fig2 = figure('Position',[1 1 600 500]);

hold on;
irfG = squeeze(irf_all(:,:,2));
plot(T,irfG(T,1)/irfG(1,5),'LineWidth',2,'color','k');

irfT = squeeze(irf_all(:,:,3));
plot(T,-irfT(T,1)/irfT(1,6),'LineWidth',2,'color','k','LineStyle','--');


iRedisY = find(strcmp(exact_soln.names,'Y'));
plot(T,exact_soln.redisIRF(iRedisY,T),'LineWidth',1,'color','k','LineStyle','-',...
    'Marker','d','MarkerSize',2);

hold off;


ylabel('\Delta Y /  \{\Delta G, \Delta tax revenue, transfer\}','FontSize',14,'Interpreter','tex')
xlabel('Quarter','FontSize',14)
legend('G', 'Tax', 'Redistribution');
box on;






disp(['G_multiplier = ' num2str(sum(irfG(1:4,1))/sum(irfG(1:4,5)))])
disp(['Tax_multiplier = ' num2str( -sum(irfT(1:4,1))/sum(irfT(1:4,6)) )])
disp(['Redistribution_multiplier = ' num2str( sum(exact_soln.redisIRF(iRedisY,1:4)) )])



