close all; clear all; clc;

global modelOptions;

fontSize = 12;


modelOptions.experiment = 0;
modelOptions.FiscalAdj = 4;
modelOptions.search = false;
modelOptions.stickyPrices = true;
modelOptions.robustness = 0;


run('FullModel/parameters/initparams');

if modelOptions.experiment > 0
    fname = ['FullModel/parameters/exper_' num2str(modelOptions.experiment)];
    run(fname);
    clear fname;
end


x = Params.knotDistrK;
nx = length(x);

laborstatus = {'employed', 'unemployed', 'long-term unemployed'};


load([Params.dirpath '/initCond/par_ex' num2str(modelOptions.experiment) '_se' num2str(modelOptions.search) '_rob' num2str(modelOptions.robustness) '.mat']);


par = par2wide(par0);








figure1 = figure('Position',[0 0 600 400])

%employed    
S = savingspline(par(Params.par_sind,2));
s = interp_savspline(S,x);
hold all
plot(x,s, 'LineWidth', 2, 'color', 'k');

%unemployed    
S = savingspline(par(Params.par_sind,5));
s = interp_savspline(S,x);
plot(x,s, 'LineStyle', '--', 'LineWidth', 2, 'color', 'k');

%needy
S = savingspline(par(Params.par_sind,8));
s = interp_savspline(S,x);
plot(x,s, 'Marker', '+', 'LineWidth', 1, 'color', 'k');

plot(x,x,'LineStyle', '--', 'LineWidth', 0.5, 'color', 'k');
hold off




xlim([-0.01 0.5]);
ylim([-0.01 0.5])
set(gca,'FontSize',fontSize)
box on;


xlabel('Assets','FontSize',14)
ylabel('Savings','FontSize',14)

% Create textbox
annotation(figure1,'textbox',...
    [0.35 0.65 0.205666666666667 0.0272727272727273],...
    'String',{'Employed'},...
    'FontSize',14,...
    'FitBoxToText','off',...
    'LineStyle','none');

% Create textbox
annotation(figure1,'textbox',...
    [0.52 0.38 0.205666666666667 0.0272727272727273],...
    'String',{'Needy'},...
    'FontSize',14,...
    'FitBoxToText','off',...
    'LineStyle','none');

% Create textbox
annotation(figure1,'textbox',...
    [0.52 0.236060606060606 0.205666666666667 0.0272727272727273],...
    'String',{'Unemployed'},...
    'FontSize',14,...
    'FitBoxToText','off',...
    'LineStyle','none');


