close all; clear all; clc;

Do_Low_Transfers = false;

Smoothing = 5;

Params.npp = 9;
Params.ndstst = 250;

load FullModel/results/experiment_0_FiscalAdj_4_search_0_sticky_1_robustness_0.mat
wealth_grid = stst_soln.wealth;
D0 = stst_soln.D;

if Do_Low_Transfers
    load FullModel/results/experiment_4_FiscalAdj_3_search_0_sticky_1_robustness_0.mat
    wealth_grid4 = stst_soln.wealth;
    D4 = stst_soln.D;

    assert(max(abs(wealth_grid - wealth_grid4)) < 1e-10)
    clear wealth_grid4;
end


%%
 

tmp = wealth_grid(1:end-1) + wealth_grid(2:end);
wlth_threshs = tmp/2;
dkdk = diff([0;wlth_threshs]);
dkdk = [dkdk;1e8];



Dtmp0= reshape(D0,Params.ndstst,Params.npp);
D0 = zeros(Params.ndstst,3);

ns = Params.npp/3;
for emp = 1:3
    D0(:,emp) = sum(Dtmp0(:,ns*(emp-1)+(1:ns)),2);
end


if Do_Low_Transfers
    Dtmp4 = reshape(D4,Params.ndstst,Params.npp);
    D4 = zeros(Params.ndstst,3);
    for emp = 1:3
        D4(:,emp) = sum(Dtmp4(:,ns*(emp-1)+(1:ns)),2);
    end
end



%% Do a bit of smoothing so the density is easier to see


tmp = kron(eye(250/Smoothing),ones(1,Smoothing));
D0 = tmp * D0;
if Do_Low_Transfers
    D4 = tmp * D4;
end
dkdk = tmp*dkdk;
wealth_grid = tmp * wealth_grid /Smoothing;

%%

figure('Color',[1 1 1],'Position',[1 1 700 500]);
emp = 1;
subplot(3,1,emp,'FontSize',14);
hold on
plot(wealth_grid(1:end-1),D0(1:end-1,emp)./dkdk(1:end-1),'color','k')
if Do_Low_Transfers
    plot(wealth_grid(1:end-1),D4(1:end-1,emp)./dkdk(1:end-1),'color','k', 'LineStyle','--')
end
%plot([-1 10], [0 0],'color', 'k', 'LineStyle','--')
xlim([-.1 5])
%ylim([-1 10])
ylabel('Density','FontSize',14)
box on
hold off
title('Employed','FontSize',14)


emp = 2;
subplot(3,1,emp,'FontSize',14);
hold on
plot(wealth_grid(1:end-1),D0(1:end-1,emp)./dkdk(1:end-1),'color','k')
if Do_Low_Transfers
    plot(wealth_grid(1:end-1),D4(1:end-1,emp)./dkdk(1:end-1),'color','k', 'LineStyle','--')
end
%plot([-1 10], [0 0],'color', 'k', 'LineStyle','--')
xlim([-.1 5])
%ylim([-1 10])
ylabel('Density','FontSize',14)
box on
hold off
title('Unemployed','FontSize',14)


emp = 3;
subplot(3,1,emp,'FontSize',14);
hold on
plot(wealth_grid(1:end-1),D0(1:end-1,emp)./dkdk(1:end-1),'color','k')
if Do_Low_Transfers
    plot(wealth_grid(1:end-1),D4(1:end-1,emp)./dkdk(1:end-1),'color','k', 'LineStyle','--')
end
%plot([-1 10], [0 0],'color', 'k', 'LineStyle','--')
xlim([-.1 5])
%ylim([-1 10])
ylabel('Density','FontSize',14)
box on
hold off
if Do_Low_Transfers
    legend('Baseline', 'Low transfers','Location','NorthEast')
end
title('Needy','FontSize',14)

xlabel('Assets (1 = avg. quarterly income)','FontSize',14)
