function [ststvpar, ststve, Evpar, Eve ] = welfare(A_MPA,B_MPA,H_MPA,ADec_Dis, par, xaggstst, Env)

global Params modelOptions;


ststvpar = par2wide(par);
ststvpar = ststvpar(1:Params.nv,:);


%compute stst value of entrepreneur  
[ ce, ne ] = welfare_unpack_agg( xaggstst,xaggstst ,Env);

if modelOptions.GHH
    ststve = log(ce - Params.psi1 * ne.^(1+Params.psi2)/(1+Params.psi2))/(1- Params.betae);
else
    ststve = (log(ce) - Params.psi1 * ne.^(1+Params.psi2)/(1+Params.psi2))/(1- Params.betae);
end


Evpar = zeros(size(ststvpar));
Eve = 0;

nmcit = 1000;
for MonteCarloIteration = 1:nmcit
    
    %simulate, starting in steady state for 500 periods
    [vpar, ve, flag] = welfare_mcit(A_MPA,B_MPA,H_MPA,ADec_Dis, ststvpar, ststve, Env);
    
    if flag == 0 % normal execution
        Evpar = Evpar + (1/nmcit) * vpar;
        Eve = Eve + (1/nmcit) * ve;
    elseif MonteCarloIteration == 1
        Evpar = Evpar + (1/nmcit) * ststvpar;
        Eve = Eve + (1/nmcit) * ststve;
    else
        Evpar = Evpar +  Evpar/(MonteCarloIteration-1);
        Eve = Eve + Eve/(MonteCarloIteration-1);
    end
        
end


