function [vpar, ve, flag] = welfare_mcit(A_MPA,B_MPA,H_MPA,ADec_Dis, ststvpar, ststve, Env)
% welfre_mcit
% executes one iteration of monte carlo integration over aggregate
% uncertainty.  simulates the economy 


global modelOptions Params;

ne = NaN;  %suppress a warning



mcSimT = 500;


Sigma = Params.Sigma;

if modelOptions.do_mpa
    ss1 = simulateSystem(A_MPA,B_MPA,H_MPA,mcSimT,Sigma);
    Dec = ADec_Dis*ss1;
    nafw = length(find(Params.aggInd.dec));
    parsim = Dec(nafw+1:end,:);
    % Move the aggregate part of Dec to ss1
    ss1 = [ss1; Dec(1:nafw,:)];
    
else
    ss1 = simulateSystem(A_MPA,B_MPA,speye(Params.ntotal),mcSimT,Sigma);
    parsim = ss1(Params.nStatesDistr-1+Params.nagg+1:end,:);
    %parsim is relative to the steady state, which we add back below
end




if modelOptions.search
    assert(size(parsim,1) == Params.npp*(Params.nv+Params.nn+Params.nc));
else
    assert(size(parsim,1) == Params.npp_n*Params.nn+Params.npp*Params.nc);
end
assert(size(parsim,2) == mcSimT);




vparnext = ststvpar;
venext = ststve;


for t = mcSimT:-1:1
    
    par = parsim(:,t);
    par = Env.parstst + par2wide(par);
    
      
    xaggr = ss1(Env.iVarAggr,t) + Env.aggstst; 
    if t > 1
        xaggr_L = ss1(Env.iVarAggr,t-1) + Env.aggstst;
    else
        xaggr_L = Env.aggstst; 
    end
    
    [ ce, ne, ii_L, laborMarketStatus, wage ] = welfare_unpack_agg( xaggr, xaggr_L, Env );
    
    
    %update value function of Entrepreneur
    if modelOptions.GHH
        ve = log(ce - Params.psi1 * ne.^(1+Params.psi2)/(1+Params.psi2)) + Params.betae * venext;
    else
        ve = log(ce) - Params.psi1 * ne.^(1+Params.psi2)/(1+Params.psi2) + Params.betae * venext;
    end
    
    
    %update value function
    %loop over this period's income state
    for ip = 1:Params.npp
        S = savingspline(par(Params.par_sind,ip));
        N = nspline(par(Params.par_nind,ip));
        
        
        
        xthis_chv =  Params.vgrid;
        xthis = exp(xthis_chv)-1;  %change of variables
        
        sthis = interp_savspline(S,xthis);
        [cthis, nthis] = get_cnt(xthis,sthis,N,1+ii_L,wage,ip);
        if ~(all(cthis > 0)) 
            disp('cthis is zero or negative')
            flag = 1;
        else
            flag = 0;
        end
        
        
        %build the expected continuatiuon value
        assets = sthis;
        Vexp = 0;
        for jp=1:Params.npp
            
            pp = transProb(ip,jp,laborMarketStatus,nthis);
            
            if any(pp>0)
                Vn = vspline(vparnext(:,jp));
                Vnext = interp_vspline(Vn,assets);
                Vexp = Vexp + pp.*Vnext;
            end
        end
        
        if modelOptions.GHH
            vpar(:,ip) = log(cthis - Params.psi1*(nthis.^(1+Params.psi2))/(1+Params.psi2)) + Params.betah*Vexp;
        else
            vpar(:,ip) = log(cthis) - Params.psi1*(nthis.^(1+Params.psi2))/(1+Params.psi2) + Params.betah*Vexp;
        end
        
        
        
    end  %close loop over this period's income state
    
    vparnext = vpar;
    venext = ve;
    
    
    
    
end

