function [ ce, ne, ii_L, laborMarketStatus, wage ] = welfare_unpack_agg( xaggr, xaggr_L,Env )

    global Params modelOptions;

    %unpack: ce, Y, G, K, KL, M
    if modelOptions.stickyPrices
        nms = {'ce', 'ne', 'Y', 'G', 'K', 'ii', 'KL', 'M', 'z', 'mpshock','markupshock'};
    else
        nms = {'ce', 'ne', 'Y', 'G', 'K', 'ii', 'KL', 'z'};
        mpshock = 0;
        M = 1/Params.mu;
    end
    
    for i = 1:length(nms)
        inm = find(strcmp(Params.aggnames,nms{i})); %#ok
        eval([nms{i} ' = xaggr(inm);']);
    end
    %unpack: ii_L, K_L
    nms = {'ii', 'K'};
    for i = 1:length(nms)
        inm = find(strcmp(Params.aggnames,nms{i})); %#ok
        eval([nms{i} '_L = xaggr_L(inm);']);
    end
    
    
    %unpack: Y_stst
    nms = {'Y'};
    for i = 1:length(nms)
        inm = find(strcmp(Params.aggnames,nms{i})); %#ok
        eval([nms{i} '_stst = Env.aggstst(inm);']);
    end
    
    
    % define a few things
    wage =  M*(1-Params.alpha)*z* KL.^Params.alpha;
    
    
    laborMarketStatus = Params.shockWeight(1) * log(z) - Params.shockWeight(2)*mpshock - (1-sum(Params.shockWeight))*markupshock;
    
    ce  = ce*(Y - G - FixedCost((Y-Y_stst)/Y_stst) -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L);
    

end

