function [ resid ] = VCNresid(nhvec, wage )
    %compute the residuals of the labor supply conditions as well as


    global Params;
    

        
    if(any(nhvec<0))  %signal inadmissible value to routine 'broydn';
        resid = 1e100;
        return;
    end
    
    % get consumptions
    C = getC(nhvec, wage);



    % hhld labor resid
    xE = wage.*Params.skill(Params.employed).*nhvec;
    margtaxE = interp_tax(xE,Params.incometax);
    
    
    resid = (1-margtaxE)./(1+Params.tauC).*wage.*Params.skill(Params.employed).*C(Params.employed).^(-Params.sigma) - Params.psi1 * nhvec.^Params.psi2; %labor supply hhld

   
  
end

