function [ resid, T ] = distresid(laborMarketStatus, exogDist_L, exogDist)
% residuals of discrete distribution update

    global Params;

    if nargin > 1
        T = initsize(zeros(Params.npp), laborMarketStatus, exogDist_L, exogDist);
    else
        T = initsize(zeros(Params.npp), laborMarketStatus);
    end
    for i = 1:Params.npp
        for j = 1:Params.npp
            T(i,j) = transProb_exog(i,j,laborMarketStatus);
        end
    end
    
    assert(all(abs(sum(T,2) - 1) < 1e-8), 'rows of T do not sum to 1');

    if nargin == 1
        resid = [];
        return
    end
    
    
    % evolution of discrete states
    ddresid = exogDist - T' * exogDist_L;
    resid = ddresid(2:end);

end

