function [resid,Env] = equ(X,Env)

global Params modelOptions;



%unpack
xcurr = X(Env.varix.x) + Env.stst;
xlag = X(Env.varix.xlag) + Env.stst;
eta = X(Env.varix.eta);
eps = X(Env.varix.eps);


% unpack stst, xagg and xagglag into local namespace
for nm_i = 1:length(Params.aggnames)
    eval([Params.aggnames{nm_i} '_stst = Env.stst(nm_i);'])
    eval([Params.aggnames{nm_i} ' = xcurr(nm_i);'])
    eval([Params.aggnames{nm_i} '_L = xlag(nm_i);'])
end

nagg = length(Params.aggnames);

nhvec_L = xlag(nagg + 1 : nagg + Params.npp_n);
nhvec = xcurr(nagg + 1 : nagg + Params.npp_n);


%unpack the dist
exogDist = par2distr(xcurr(nagg+Params.npp_n + 1:end),Env);
exogDist_L = par2distr(xlag(nagg+Params.npp_n + 1:end),Env);


%convert ce and Inv
ce  = ce*(Y - G - FixedCost((Y-Y_stst)/Y_stst) -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L);
Inv = Inv*(Y - G - FixedCost((Y-Y_stst)/Y_stst) -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L);

ce_L  = ce_L*(Y_L - G_L - FixedCost((Y_L-Y_stst)/Y_stst) -  Params.Psi/2 * ((K_L-Klag_L)/Klag_L).^2 * Klag_L);
Inv_L = Inv_L*(Y_L - G_L - FixedCost((Y_L-Y_stst)/Y_stst) -  Params.Psi/2 * ((K_L-Klag_L)/Klag_L).^2 * Klag_L);



if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 2 || modelOptions.FiscalAdj == 6
    LumpSumTax = Params.LumpSumTax;
end
if modelOptions.FiscalAdj == 1  || modelOptions.FiscalAdj == 2  || modelOptions.FiscalAdj == 5
    fixedCosts = FixedCost(0);
    GDP = Y_stst - fixedCosts;
    B_stst = Params.debt2GDP * GDP;
    B = B_stst;
    B_L = B_stst;
    clear fixedCosts GDP;
end
if modelOptions.FiscalAdj == 6
    tauK = Params.tauK + dtau;
    tauC = Params.tauC + dtau;
    tauP = Params.tauP + dtau;
    tauP_L = Params.tauP + dtau_L;
    tauC_L = Params.tauC + dtau_L;
    tauK_L = Params.tauK + dtau_L;
    taxshock = dtau;
    taxshock_L = dtau_L;
else
    tauK = Params.tauK;
    tauC = Params.tauC;
    tauP = Params.tauP;
    tauP_L = Params.tauP;
    tauC_L = Params.tauC;
    tauK_L = Params.tauK;
    taxshock = 0;
    taxshock_L = 0;
end

if ~modelOptions.stickyPrices
    M = 1/Params.mu;
    M_L = M;
    S = 1;
    ppi = 1;
end


%calculate wages and interest rates
wage =  M*(1-Params.alpha)*z* KL.^Params.alpha;
wage_L =  M_L*(1-Params.alpha)*z_L* KL_L.^Params.alpha;
rhat =  -Params.delta + M*Params.alpha*z* KL.^(Params.alpha-1);
r = (1-tauK)/(1-tauK*Params.upsilon) * rhat;

%Dividends
fixedCosts = FixedCost((Y-Y_stst)/Y_stst);
after_tax_div_intermed = (1-tauK)*(Y - M * z * K_L.^Params.alpha * N.^(1-Params.alpha) - fixedCosts);
revenue_from_corporate_inc_tax = tauK*(Y - M * z * K_L.^Params.alpha * N.^(1-Params.alpha) - fixedCosts) ...
    + tauK*(1-Params.upsilon)/(1-Params.upsilon*tauK)*rhat*K_L;
%for div_cap see below
dividend =  after_tax_div_intermed + div_cap - tauP*firmValue;



%entrepreneur's income tax rates
[margtaxe, taxpaide] = interp_tax(xe,Params.incometax);
margtaxe_L = interp_tax(xe_L,Params.incometax);
margtaxe_stst = interp_tax(xe_stst,Params.incometax);



if modelOptions.stickyPrices
    laborMarketStatus = Params.shockWeight(1) * log(z) - Params.shockWeight(2)*mpshock - (1-sum(Params.shockWeight))*markupshock;
    laborMarketStatus = Params.shockWeight(1) * log(z_L) - Params.shockWeight(2)*mpshock_L - (1-sum(Params.shockWeight))*markupshock_L;
else
    laborMarketStatus = log(z);
    laborMarketStatus_L = log(z_L);
end


%net investment
netI = Inv-Params.delta*K_L;
netI_L = Inv_L - Params.delta*Klag_L;
%netI = K - K_L;
%netI_L = K_L - Klag_L;


% hhld budget variables
%Employed


%totals
[ Chvec, taxpaidh ] = getC( nhvec, wage,taxshock);
ch = sum(exogDist_L .* Chvec) * Params.nu;
taxpaidh = sum(exogDist_L .* taxpaidh);

% add up the labor supply of employed workers
% it is tempting to use sum() here, but that breaks linearization step
% there must be a problem with how sum() is implemented in the deriv1
% class as it seems to cast the result not as sparse
nh = 0;
hrsh = 0;
for i = 1:Params.npp_n
    nh = nh + exogDist_L(i).*Params.skill(i).*nhvec(i) * Params.nu;
    hrsh = hrsh + nhvec(i).*exogDist_L(i)*Params.nu;
end


tmp = Params.Tu + Params.To;
transferspending = sum(exogDist_L .* tmp) * Params.nu;


% ---- aggregate equations

resAgg = initsize(zeros(Params.nagg,1),X);

equCount = 0;
resAgg(equCount+1) = log(z)-Params.rhoz*log(z_L)-eps(1);  %AR(1)
resAgg(equCount+2) = Gshock - Params.rhoG*Gshock_L -eps(2);
equCount = equCount + 2;

if modelOptions.stickyPrices
    resAgg(equCount+1) = -mpshock + Params.rhomp * mpshock_L + eps(3);
    resAgg(equCount+2) = -markupshock + Params.rhomarkup * markupshock_L + eps(4);
    equCount = equCount + 2;
end


%resAgg(equCount+1) = (K + C + G) - (Y + (1-Params.delta)*K_L - Params.fixedCost -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L);  %agg res con


resAgg(equCount+1) = B + ce*(1+tauC) + K -  K_L - B_L/ppi - (xe - taxpaide) + LumpSumTax;  % budget const  cap owner


resAgg(equCount+2) = -B  + B_L*(1 + ii_L)/ppi + G + transferspending - Params.nu*taxpaidh - taxpaide - LumpSumTax ...
    - tauC*C - firmValue*tauP - revenue_from_corporate_inc_tax; %gov budg


resAgg(equCount+3) = KL - K_L/N;  % def of KL
resAgg(equCount+4) = Y*S - z * K_L.^Params.alpha * N.^(1-Params.alpha);


resAgg(equCount+5) = -N + (nh + Params.skille*nne);  %def of N
resAgg(equCount+6) = Params.psi1*nne.^(Params.psi2) - ce.^(-Params.sigma).*Params.skille*wage*(1-margtaxe)/(1+tauC); %entrepreneur labor supply
resAgg(equCount+7) = -xe + B_L/ppi*ii_L + Params.skille*nne*wage + dividend;

resAgg(equCount+8) = ce + ch - C;
resAgg(equCount+9) = Klag - K_L;

resAgg(equCount+10) = -div_cap +  r *K_L - K + K_L - Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L;

resAgg(equCount+11) = Hrs - (hrsh + nne);

resAgg(equCount+12) =  -K + (1-Params.delta)*K_L+Inv;        %capital update

equCount = equCount + 12;

if modelOptions.stickyPrices
    resAgg(equCount+1) = -ii + ii_stst + Params.phiP*(ppi-1) + Params.phiY*log(Y/Y_stst) +  mpshock;
    
    resAgg(equCount+2) = -ppi + ((1-Params.theta)/(1-Params.theta*pstar.^(1/(1-Params.mu)))).^(1-Params.mu);  % pi
    
    resAgg(equCount+3) = -pstar + pbarA/pbarB; %pstar
    
    resAgg(equCount+4) = -S + (1-Params.theta)*S_L*ppi.^(-Params.mu/(1-Params.mu))...
        +Params.theta*pstar.^(Params.mu/(1-Params.mu));  % price dispersion
    
    equCount = equCount + 4;
end



if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 1
    resAgg(equCount+1) = -G +  G_stst * (B_L/B_stst).^Params.phiLST + Gshock;  %fiscal policy rule
    equCount = equCount + 1;
elseif modelOptions.FiscalAdj == 3
    resAgg(equCount+1) = -G +  G_stst  + Gshock;
    resAgg(equCount+2) = LumpSumTax - log((B_stst./B_L).^Params.phiLST) - LumpSumTax_stst;
    equCount = equCount +2;
elseif modelOptions.FiscalAdj == 4
    resAgg(equCount+1) = -log(G-Gshock) + log(G_stst) + (-Params.phiG/Params.phiLST) * (LumpSumTax - LumpSumTax_stst);
    resAgg(equCount + 2) = LumpSumTax - log((B_stst./B_L).^Params.phiLST) - LumpSumTax_stst;
    equCount = equCount + 2;
elseif modelOptions.FiscalAdj == 5
    resAgg(equCount+1) = -G +  G_stst  + Gshock;
    equCount = equCount + 1;
elseif modelOptions.FiscalAdj == 6 
    resAgg(equCount+1) =-log((G-Gshock)) + log(G_stst) + (-Params.phiG/Params.phiLST*Params.taxbase) * dtau;
    resAgg(equCount + 2) = dtau - log((B_stst./B_L).^(Params.phiLST/Params.taxbase));
    equCount = equCount + 2;
else
    assert(modelOptions.FiscalAdj == 2)
end

%this is SDF for entrepreneur
SDF = Params.betae * ce.^(-Params.sigma) / ce_L.^(-Params.sigma) * (1+tauC_L)/(1+tauC);



taxRatio = (1-margtaxe)/(1-margtaxe_L);

resAgg(equCount+1) =  -SDF*(1 + ii_L*(1-margtaxe))/ppi + 1 + eta(1);  %risk-free pricing
resAgg(equCount+2) = -taxRatio*SDF/(1+tauP)*(1 + r  - (Params.Psi/2)*(netI/K_L).^2 + Params.Psi*(netI/K_L)*(K/K_L))...
    + (1+Params.Psi*(netI_L/Klag_L)) + eta(2); %euler K

resAgg(equCount+3) = -firmValue_L*(1 + tauP_L) + div_cap_L + taxRatio*SDF * firmValue + eta(3);

equCount = equCount + 3;

if modelOptions.stickyPrices
    resAgg(equCount+1) = -pbarB_L + Y_L*(1-tauK_L)/(1-Params.tauK) + taxRatio*SDF*(1-Params.theta)*ppi.^(-Params.mu/(1-Params.mu)-1)*pbarB +eta(4); % pbarB
    resAgg(equCount+2) = -pbarA_L + M_L*Params.mu*Y_L*(1-tauK_L)/(1-Params.tauK) + taxRatio*SDF*(1-Params.theta)*ppi.^(-Params.mu/(1-Params.mu))*pbarA + markupshock_L +eta(5); % pbarA
    equCount = equCount + 2;
end


%residuals of labor supply
resid_hhld = VCNresid( nhvec,  wage);
%residuals of distribution update
resid_dist = distresid(laborMarketStatus, exogDist_L, exogDist);


resid = [resAgg; resid_hhld; resid_dist];



end