function [ C taxpaid ] = getC( nhvec, wage, taxshock)

    global Params;

    if nargin < 3
        taxshock = 0;
    end
    
    C = initsize(zeros(Params.npp,1),nhvec,wage);
    taxpaid = initsize(zeros(Params.npp,1),nhvec,wage);
    
    
    for i = 1:Params.npp
        switch Params.estatus(i)
            case 1                
                %employed
                xE = wage.*Params.skill(i).*nhvec(i);
                [~, taxpaid(i)] = interp_tax(xE,Params.incometax,taxshock);
                C(i) = (xE - taxpaid(i))/(1+Params.tauC+taxshock);
            case 2
                %Unemployed
                xU = Params.Tu(i);
                [~, taxpaid(i)] = interp_tax(xU,Params.incometax,taxshock);
                C(i) = (xU - taxpaid(i))/(1+Params.tauC+taxshock);
            case 3
                %NLF
                C(i) = Params.To(i)/(1+Params.tauC+taxshock);
                taxpaid(i) = 0;
        end
    end
end

