global Params;



%% Scalars

Params.seed = 2.116921967000000e+05;

Params.freq = 4;

%preferences
Params.betah = 0.978961862738;  %household discount factor, see calibrate.m
Params.sigma = 1;     %risk aversion
Params.psi1 = 19.6855103766; % labor supply parameter
Params.psi2 = 2; % labor supply parameter
Params.betae = 0.988830128237;


%markets
Params.mu = 1.1;
Params.theta = 1/3.5;

%production
Params.fixedCost = [0.57528560756 0];
Params.alpha = 1 - (1-0.36) * Params.mu;  % capital share
Params.delta = 0.0456/4; % depreciation


%government
Params.debt2GDP = 1.69781919145;  % stst debt to GDP ratio
Params.tauC = 0.053544485989;
Params.tauP = 0.00258317982938;
Params.tauK = 0.35;  
Params.GonY = 0.145291631621;  
Params.upsilon = 0.679552793355;


%entrepreneur/hhld distribution
Params.nu = 4;
Params.skille = 3.71838356684; %see calibrate.m



%calibration targets used by calibrate.m:
%Params.incomeshare = 0.407;   %see Castaneda et al
%Params.assetshare = 0.714;   %see Castaneda et al
Params.incomeshare = 0.525;   %see Castaneda et al
Params.assetshare = 0.834;   %see Castaneda et al
Params.avgLaborSupplystst = 0.31;
Params.earningsshare = 0.48;




%Parameters for dynamics



Params.SigmaEpsz = 0.002936169743355;  % st dev of z shock
Params.rhoz = 0.75; % persistence of z shock

Params.SigmaG = 0;
Params.rhoG = 0;

Params.SigmaEpsmp = 0.003533607840688; % st dev of MP shock
Params.rhomp = 0.62; % persistence

Params.Sigmamarkup =  0.025141071226995;
Params.rhomarkup = 0.85;

Params.phiLST =  -1.6;  % fiscal adjustment speed parameter
Params.phiG = 0.8*Params.phiLST;


Params.phiP = 1.55;
Params.phiY = 0.0;
Params.phii = 0.0;

Params.Psi =  6.0;  %capital adj cost

Params.shockWeight =  [ 0.639337048621449  0.317676504487140];  


if modelOptions.stickyPrices
    Params.Sigma = diag([Params.SigmaEpsz; Params.SigmaG; Params.SigmaEpsmp; Params.Sigmamarkup]);
else
    Params.Sigma = diag([Params.SigmaEpsz; Params.SigmaG]);
end




%% Household heterogeneity and income process
Params.npp = 9; %number of discrete household types.
                %you can use this to control "big" model with npp = 9
                %or small model (no skill differences) with npp = 3
                
Params.npp_n = Params.npp/3; %number of discrete household who work


if Params.npp == 3

     Params.skill = 1.0809; %wage grid
     Params.wageTrans = 1;

     if modelOptions.experiment == 6 || modelOptions.experiment == 7
         Params.skill = 0.7024;
     end
     
      nwage = 1;

else
    
   Params.wage_scale_parameter = 0.0541258126838;
    
    % full wage process
    load wage_process;
    Params.skill = Params.wage_scale_parameter * wage_grid;
    Params.wageTrans = wage_trans;
    

   
   nwage = length(Params.skill);
   
   
   
   assert(length(Params.skill) == Params.npp/3,'Inconsistency between length of wage grid and Params.npp');
   
   
end

% It is crucial that skill = 0 for those not employed
Params.skill = [Params.skill; zeros(length(Params.skill)*2,1)]; 


Params.employed = logical([ones(1,nwage) zeros(1,nwage*2)]);  %note: make sure that this is organized as 1 1 1 1 0 0 0 0 
Params.estatus = kron(1:3,ones(1,nwage));
Params.sstatus = kron(ones(1,3),1:nwage);



%labor market transition probabilities
 Params.LFtransMat_ss = [   0.969425752923931   0.030574247076069                   0
   0.539801877892624   0.194832843834118   0.265365278273258
   0.087327000000000                   0   0.912673000000000];


% labor market fluctuations
Params.LFtransMat_z = [ 0   -2.812554072258800       0;
                        0  0    0;
                       2.325866859407174        0   0];  %this row is set internally (see transProb.m)


Params.LFtransMat_z = Params.LFtransMat_z + diag(zeros(3,1) - sum(Params.LFtransMat_z,2));
Params.LFtransMat_z_nonLinear = Params.LFtransMat_z./(max(Params.LFtransMat_ss,1e-10).*(1-Params.LFtransMat_ss));




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% set up ui and other benefits
Params.TuMaxBenefit = 0.66; %0.66 is 66% of average income
Params.TuSkillWeight = 0.143944552513;
Params.Tu = min(kron([0;1;0], Params.TuSkillWeight*Params.skill(Params.employed)),Params.TuMaxBenefit);  

Params.To = kron([0;0;0.150849010446], ones(Params.npp_n,1)); % other social benefits



%% Income Tax Function

load incometax;
Params.incometax = incometax; clear incometax;

%Add a constant to tax function so that it generates aggregate income tax
%revenues.
taxConstant = -0.062;  % adjust intercept of income tax  
Params.incometax.marg(end) = Params.incometax.marg(end) + taxConstant;
Params.incometax.cumul(end-1) = Params.incometax.cumul(end-1) + taxConstant;
Params.incometax.breakval = Params.incometax.breakval + taxConstant;


%% Aggregate variables

if modelOptions.stickyPrices
    Params.nz = 4; % number of exogenous var

    Params.nAggEta = 5; % number of expectational errors in aggregate equations
    
else
    Params.nz = 2;
    Params.nAggEta = 3;
end


exog = {'z', 'Gshock', 'mpshock', 'markupshock'};
other_states = {'K'};
if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 3 || modelOptions.FiscalAdj == 4 || modelOptions.FiscalAdj == 6
    other_states = {other_states{:}, 'B'};
end
static = {'KL', 'Y',  'N',  'G',  'nne',...
    'xe', 'C', 'pstar', 'ppi', 'Klag', 'S', 'div_cap', 'M', 'Hrs', 'ii'};
if modelOptions.FiscalAdj == 1 || modelOptions.FiscalAdj == 3 || modelOptions.FiscalAdj == 4 || modelOptions.FiscalAdj == 5
    static = {static{:}, 'LumpSumTax'};
elseif modelOptions.FiscalAdj == 6
    static = {static{:}, 'dtau'};
end
dec = { 'Inv', 'ce', 'firmValue', 'pbarA', 'pbarB'};

Params.aggnames = {exog{:}, other_states{:}, static{:}, dec{:}};

if ~modelOptions.stickyPrices
    %delete the followoing variables from the system
    delVar = {'S','M','pbarA','pbarB', 'pstar', 'ppi', 'mpshock'};
   
    I = ones(size(Params.aggnames));
    for i = 1:length(delVar)
        I = I.*(~strcmp(Params.aggnames,delVar{i}));
    end
    I = logical(I);
    Params.aggnames = Params.aggnames(I);
    
end

Params.nagg = length(Params.aggnames);


% create indices
n = length(exog)+length(other_states);
Params.aggInd.state = logical([ones(1,n) zeros(1,Params.nagg-n)]);

n = length(dec);
Params.aggInd.dec = logical([zeros(1,Params.nagg-n) ones(1,n)]);

n = length(exog);
Params.aggInd.exog = logical([ones(1,n) zeros(1,Params.nagg-n)]);

Params.aggInd.static = ~logical(Params.aggInd.state + Params.aggInd.dec);
