function [x_resid Env resid] = solveForSS(X)

    global Params modelOptions;


    xe_in = X(1);
    ne_in = X(2);

    
    nne = ne_in;
    
        
    if ne_in<0
        x_resid = [0; 10];
        return;
    end
    
    [margtaxe, taxpaide] = interp_tax(xe_in, Params.incometax);

    margtaxe_track =  margtaxe;  
    
    [ z, M, wage, ii, r, rhat, KL] = SteadyStatePrices( margtaxe );
    
    %solve for steady state
    
    mpshock = 0; %#ok
    Gshock = 0; %#ok
    markupshock = 0; %#ok
    S = 1; %#ok
    ppi = 1; %#ok
    pstar = 1;%#ok
    
    
    YonN = KL^Params.alpha;

    
    
    GonN = Params.GonY * YonN;
    ConN = YonN - Params.delta*KL - GonN; % excludes fixed cost
    
    
    nhvec = steadyNV(wage);
    
    laborMarketStatus = 0;
    [~, T ] = distresid(laborMarketStatus);
    exogDist = invdistr(T');
    [cvec, taxpaidh] = getC( nhvec, wage);
    
    
    
    nh = Params.nu * sum(nhvec.*Params.skill(Params.employed).*exogDist(Params.employed));
    ch = Params.nu * dot(exogDist,cvec);

    
    effectiveN = nh + Params.skille*ne_in;
    N = effectiveN;
    Hrs = Params.nu * sum(nhvec(Params.employed).*exogDist(Params.employed)) + ne_in;
    
    C = ConN * effectiveN - FixedCost(0);
    K = KL * effectiveN;
    Y = YonN * effectiveN;
    G = GonN * effectiveN;
    
    
    assert(abs(C + Params.delta*K + G - (Y-FixedCost(0))) < 1e-10, 'resource constraint fails')
       
    

    pbarA = Y/(1-Params.betae*(1-Params.theta));
    pbarB = pbarA; %#ok

    
    Klag = K; %#ok
    
    
    %Dividends
    div_cap = r*K;
    firmValue = div_cap/(1+Params.tauP-Params.betae);
    
  
    fixedCosts = FixedCost(0);
    after_tax_div_intermed = (1-Params.tauK)*(Y - M * z * K.^Params.alpha * N.^(1-Params.alpha) - fixedCosts);
    revenue_from_corporate_inc_tax = Params.tauK*(Y - M * z * K.^Params.alpha * N.^(1-Params.alpha) - fixedCosts) ...
                                     + Params.tauK*(1-Params.upsilon)/(1-Params.upsilon*Params.tauK)*rhat*K;
    
    dividend =  after_tax_div_intermed + div_cap - Params.tauP*firmValue;
  
    
    
  
    
   
    GDP = Y - fixedCosts;
    B = Params.debt2GDP * GDP;
    
    
    
    
    xe =  ii * B + wage*Params.skille*ne_in + dividend;
    
    
    
    taxpaidh = dot(taxpaidh, exogDist)*Params.nu;

    taxpaid = taxpaide + taxpaidh;
    
    
    
    transferSpending = Params.nu*dot(exogDist,Params.To+Params.Tu);


   
   revenue = taxpaid + Params.tauC*C...
         + firmValue*Params.tauP + revenue_from_corporate_inc_tax;

    expenditure = G + B*ii + transferSpending;
    
    %exp2gdp = expenditure / GDP
    
    %rev2gdp = revenue / GDP
    
    netInterestExpense = B*ii/GDP;

    LumpSumTax = expenditure - revenue;
    
    if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 2 || modelOptions.FiscalAdj == 6
        Params.LumpSumTax = LumpSumTax;
    end

    if modelOptions.FiscalAdj == 6
        dtau = 0;
        Params.taxbase = xe+ ch*(1+Params.tauC)+taxpaidh + revenue_from_corporate_inc_tax/Params.tauK + firmValue + C;
    end
    
    
    ce = C - ch;
    
    lse_resid = (1-margtaxe)/(1+Params.tauC)*wage*Params.skille*ce^(-Params.sigma) - Params.psi1 * ne_in^Params.psi2;
    
    
    
    x_resid = [xe-xe_in; lse_resid];
    if nargout == 1, return; end
    
    
    Inv = Params.delta*K;
    
    ce = ce/(Y-G-FixedCost(0));
    Inv = Inv/(Y-G-FixedCost(0));
    
    
    for nm_i = 1:length(Params.aggnames)
        eval(['Env.stst(nm_i) = ' Params.aggnames{nm_i} ';']) 
    end

    Env.Dstst = exogDist;
    % package results: agg, nhvec, V, exogDist(2:end)
    Env.stst = [Env.stst nhvec' zeros(1,Params.npp-1)];
    
    
    
    
    Env.stst = Env.stst'; %#ok

    %Below here is for calibration 
%    if nargout < 3, return; end

    
    U = sum(exogDist(Params.Tu>1e-6))*Params.nu;
    NLF = sum(exogDist(Params.To>1e-6))*Params.nu;
   
    div_intermed = Y - M * z * K.^Params.alpha * N.^(1-Params.alpha) - fixedCosts...
        + Params.tauK*(1-Params.upsilon)/(1-Params.upsilon*Params.tauK)*rhat*K;
    r = (1-Params.upsilon*Params.tauK)/(1-Params.tauK)*rhat;
    
    n = (nh + nne)/(Params.nu + 1);
    x = (ch+taxpaidh + xe)/(Params.nu + 1);
    resid = [n-0.31;  %average hours
            x-1; %average income
            taxpaid/GDP-0.10976; %income tax revenue
            sum(exogDist.*Params.Tu*Params.nu)-0.003352 * GDP/U; %average expenditure on transfers
            sum(exogDist.*Params.To*Params.nu)-0.01046*GDP/NLF; % "
            Params.tauC-0.03847*GDP/C; %consumption tax revenue
            firmValue*Params.tauP/GDP - 0.02790;  %revenue raised from property tax
            K/GDP - 4*2.67; %cap-output ratio
            G/GDP - 0.15978;  %G / GDP
            netInterestExpense - 0.02825; % government's net interest expense to GDP
            (div_intermed + (1-Params.upsilon)*r*K)/GDP - 0.09132945];  %corporate profits to GDP

        
end
