function irf = DebtIRF(G,Env)
% construct impulse response to debt shock

global Params;

iB = find(strcmp(Params.names,'B'));
iR = find(strcmp(Params.names,'revenue'));
iG = find(strcmp(Params.names,'G'));
iT = find(strcmp(Params.names,'transferspending'));

x = zeros(size(G,1),1);

x(iB) = 1;

H2 = zeros(3,length(x));
H2(1,iB) = 1;
H2(2,iR) = 1; H2(2,iT) = -1;
H2(3,iG) = 1;

irf = zeros(size(H2,1),60);
for i = 1:length(irf)
    irf(:,i) = H2*x;
    x = G*x;
end


SS = [Env.stst(iB); Env.stst(iR)-Env.stst(iT); Env.stst(iG)] * ones(1,60);

irf = irf + SS;
irf = log(irf) - log(SS);

irf = irf/irf(1,1);