function [EE, LSE] = EulerError(G1,impact,Env,nerr,nSimBetweenError)
%EULERERROR Simulates the economy and computes Euler equation errors and labor supply errors at
%randomly generated state vectors

global Params;

EE = NaN(2,nerr);
LSE = NaN(1,nerr);

%simulate for nerr * nSimBetweenError periods
T = nerr * nSimBetweenError;
Sigma = Params.Sigma;
nshock = size(impact,2);
shocks = randn(T,nshock)';  %the RNG populates the matrix column by column so forming the matrix this way and then transposing it means that we get the same shocks even if we leave off some columns.
state = zeros(size(impact,1),1);
for t = 1:T
    state_L = state;
    state = G1*state + impact*Sigma*shocks(:,t);
    if mod(t,nSimBetweenError) == 0
         [EE(:,t/nSimBetweenError), LSE(1,t/nSimBetweenError)] = EulerError_at_a_state( state+Env.stst, state_L+Env.stst , G1, impact, Env);
    end
end

Linf = log10(max(abs(EE)'));
L1 = log10(mean(abs(EE)'));
disp(' ')
disp('Euler equation errors in log10')
disp('          investment    bond')
disp(['largest  ' num2str(Linf)])
disp(['mean     ' num2str(L1)])


Linf = log10(max(abs(LSE)'));
L1 = log10(mean(abs(LSE)'));
disp(' ')
disp('Labor supply errors in log10')
disp(['largest  ' num2str(Linf)])
disp(['mean     ' num2str(L1)])


end

function [ EEAgg, labor_supply_error ] = EulerError_at_a_state( XX, XXlag , G1, impact, Env)
%EULERERROR Summary of this function goes here

global Params;

EXXpp = G1*(XX - Env.stst) + Env.stst;
[C_L, ~, K_L, Klag_L, margtax_L, ii_L, ~, XXtil, labor_supply_error ]  = EulerError_nonlinear( XX, XXlag, EXXpp , Env);

%prepare for numerical integration over the aggregate shocks

n = [11 11 11];
mu = zeros(1,3);
var = diag([Params.SigmaEpsz Params.SigmaEpsmp Params.Sigmamarkup])^2;
[x, w] = qnwnorm(n,mu,var);
x = [x(:,1) zeros(prod(n),1) x(:,2:3)];  %add zero for govt spending shocks.


netI_L = K_L - Klag_L;
EEAgg_LHS_coefs = [(1+Params.Psi*(netI_L/Klag_L))*(1-margtax_L)
                    1];

%Loop over the quadrature grid
EEAgg = [0;0];  %this will store two euler equations: [investment; bond]
EXXpp = XXtil;  %this is just for speed b/c we do not need to calculate ii in the inner loop
for i = 1:prod(n)
    
    %find the decisions given a shock realization
    XXp = Env.stst + G1*(XXtil-Env.stst) +  impact *  x(i,:)';
    
    
    [C, r, K, ~, margtax,~,ppi] = EulerError_nonlinear( XXp, XXtil, EXXpp  , Env);    %note
    
    %compute the integrand inside the expectation 
    netI = K - K_L;
    eeAgg = Params.beta / C *[1/(1+Params.tauP)*(1-margtax)*(1 + r  - (Params.Psi/2)*(netI/K_L).^2 + Params.Psi*(netI/K_L)*(K/K_L)) 
                                (1 + ii_L*(1-margtax))/ppi];
    
    
    
         
    %integrate using quadrature weights
    EEAgg = EEAgg + w(i) * eeAgg;
end

EEAgg = EEAgg./EEAgg_LHS_coefs;

EEAgg = 1./EEAgg/C_L -1;



end
function [C, r, K, Klag, margtax, ii, ppi, XXtil, labor_supply_error ] = EulerError_nonlinear( XX, XXlag, EXXprime, Env)
%EULERERROR_nonlinear takes a vector of variables and imposes some
%non-linear relationships.
%   XX   a simulated point at which to calculate the error.  it contains all
%   variables, but we will only read out the state variables and certain
%   forward looking variables.
%
%   XXtil update some of the values in x based on non-linear equations.

global Params modelOptions;

%1) read out some state and forward-looking variables from x
nms = {'z', 'Gshock', 'mpshock', 'markupshock',...
        'M','C', 'N','ppi', 'pstar', 'firmValue','S','Klag',...
        'pbarA', 'pbarB'};
for i = 1:length(nms)
    inm = find(strcmp(Params.names,nms{i})); %#ok
    eval([nms{i} ' = XX(inm);']);
end        



%2) read out some state variables from xlag    
nms = {'U', 'NLF', 'skill','S', 'K','B','ii','C'};
for i = 1:length(nms)
    inm = find(strcmp(Params.names,nms{i})); %#ok
    eval([nms{i} '_L = XXlag(inm);']);
end


%3) read out some variable from steady state   
nms = {'ii','Y','G','B','LumpSumTax','margtax_track'};
for i = 1:length(nms)
    inm = find(strcmp(Params.names,nms{i})); %#ok
    eval([nms{i} '_stst = Env.stst(inm);']);
end

%3.5) read out some variable from E(x')
nms = {'margtax_track'};
for i = 1:length(nms)
    inm = find(strcmp(Params.names,nms{i})); %#ok
    eval([nms{i} '_E = EXXprime(inm);']);
end

%4) calculate some variables from exact equations

%a) inflation
pstar =  pbarA/pbarB; 
ppi = ((1-Params.theta)...
       /(1-Params.theta*pstar.^(1/(1-Params.mu)))).^(1-Params.mu);

%b) price dispersion
S = (1-Params.theta)*S_L*ppi.^(-Params.mu/(1-Params.mu))...
        +Params.theta*pstar.^(Params.mu/(1-Params.mu));
    
    
%c) output from production function
effectiveN = skill_L * N;
Y = (z * K_L.^Params.alpha * effectiveN.^(1-Params.alpha)) / S;

%d) prices from firm FOCs
KL = K_L / effectiveN;
wage =  M*(1-Params.alpha)*z* KL.^Params.alpha;
rhat =  -Params.delta + M*Params.alpha*z* KL.^(Params.alpha-1);
r = (1-Params.tauK)/(1-Params.tauK*Params.upsilon) * rhat;

%e) government policies
ii = ((1-margtax_track_stst)*ii_stst + Params.phiP*(ppi-1) + Params.phiY*log(Y/Y_stst) +  mpshock)/(1-margtax_track_E);

   
assert( modelOptions.FiscalAdj == 4)
LumpSumTax = log((B_stst./B_L).^Params.phiLST) + LumpSumTax_stst;
G = exp(log(G_stst) + (-Params.phiG/Params.phiLST)...
    * (LumpSumTax - LumpSumTax_stst));




% f) agg res constraint--> solve for K
tmp_a = Params.Psi/2 /K_L;
tmp_b = 1 - Params.Psi;
tmp_c = -(Y + (1-Params.delta)*K_L - FixedCost((Y-Y_stst)/Y_stst) ...
    -Params.Psi/2 * K_L - G - C);

K = (-tmp_b + sqrt(tmp_b^2-4*tmp_a*tmp_c))/(2*tmp_a);

Kalt = (-tmp_b - sqrt(tmp_b^2-4*tmp_a*tmp_c))/(2*tmp_a);
assert(K > Kalt)

assert(abs((K + C + G) - (Y + (1-Params.delta)*K_L - FixedCost((Y-Y_stst)/Y_stst)...
    -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L))<1e-7)



% g) government debt from budget      
after_tax_div_intermed = (1-Params.tauK)*(Y - M * z * K_L.^Params.alpha...
    * effectiveN.^(1-Params.alpha) - FixedCost((Y-Y_stst)/Y_stst));
div_cap =  r *K_L - K + K_L - Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L;
dividend =  after_tax_div_intermed + div_cap - Params.tauP*firmValue;

x = B_L*ii_L/ppi + effectiveN*wage + dividend + Params.Tu(2)*U_L;

[margtax, taxpaid] = interp_tax(x/(1+Params.nu),Params.incometax);
taxpaid = taxpaid*(1+Params.nu);

if nargout < 8, return; end

E_L = Params.nu - NLF_L - U_L;
tmp = Params.Tu + Params.To;
transferspending = E_L*tmp(1) + U_L*tmp(2) + NLF_L*tmp(3);  

revenue_from_corporate_inc_tax = Params.tauK*(Y - M * z * K_L.^Params.alpha * effectiveN.^(1-Params.alpha) - FixedCost((Y-Y_stst)/Y_stst)) ...
    + Params.tauK*(1-Params.upsilon)/(1-Params.upsilon*Params.tauK)*rhat*K_L;

revenue = taxpaid + LumpSumTax ...
    + Params.tauC*C + firmValue*Params.tauP ...
    + revenue_from_corporate_inc_tax;

B = B_L/ppi*(1 + ii_L) + G  + transferspending - revenue; %gov budg


% h) update U, NLF
if modelOptions.stickyPrices
    laborMarketStatus = Params.shockWeight(1) * log(z) - Params.shockWeight(2)*mpshock - (1-sum(Params.shockWeight))*markupshock;
else
    laborMarketStatus = Params.shockWeight * log(z);
end

stocks_pred = transProb_exog([1;2;3],[1;2;3],laborMarketStatus)' * [E_L; U_L; NLF_L];
U = stocks_pred(2);
NLF = stocks_pred(3);
E = Params.nu - NLF - U;
sep = 1 + 1/Params.psi2;
skill = ((Params.sbar^sep + Params.smeanofhhlds^sep*E)/(1+E)).^(1/sep);

% 5) package results back into x
XXtil = XX;
nms = { 'K', 'B',  'U', 'NLF', 'skill', 'LumpSumTax', 'KL', 'Y',  'G', 'div_cap',...
        'x','S', 'ppi','pstar',  'ii', 'revenue', 'transferspending'};    

for i = 1:length(nms)
    inm = find(strcmp(Params.names,nms{i})); %#ok
    eval(['XXtil(inm) = ' nms{i}  ';']);
end  


% 6) compute labor supply residual
Nhat = (1+E_L)*((1-margtax)/(1+Params.tauC)*wage*skill_L*C.^(-Params.sigma)/Params.psi1).^(1/Params.psi2);
labor_supply_error = Nhat/N - 1;


end

