function [resid,Env] = equ(X,Env)

global Params modelOptions;

ne = NaN;

xcurr = X(Params.ix) + Env.stst;
xlag = X(Params.ixlag) + Env.stst;
eta = X(Params.ieta);
eps = X(Params.ieps);



for nm_i = 1:length(Params.names)
    eval([Params.names{nm_i} ' = xcurr(nm_i);'])
    eval([Params.names{nm_i} '_L = xlag(nm_i);'])
    eval([Params.names{nm_i} '_stst = Env.stst(nm_i);'])
end


if modelOptions.experiment == 7
    G = 0;
    G_L=0;
end

Ctmp  = Crat*(Y - G - FixedCost((Y-Y_stst)/Y_stst) -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L);
Inv = Inv*(Y - G - FixedCost((Y-Y_stst)/Y_stst) -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L);

Ctmp_L  = Crat_L*(Y_L - G_L - FixedCost((Y_L-Y_stst)/Y_stst) -  Params.Psi/2 * ((K_L-Klag_L)/Klag_L).^2 * Klag_L);
Inv_L = Inv_L*(Y_L - G_L - FixedCost((Y_L-Y_stst)/Y_stst) -  Params.Psi/2 * ((K_L-Klag_L)/Klag_L).^2 * Klag_L);



resAgg = initsize(zeros(Env.nx,1),X);



if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 2 || modelOptions.FiscalAdj == 6
    LumpSumTax = Params.LumpSumTax;
end
if modelOptions.FiscalAdj == 1  || modelOptions.FiscalAdj == 2 || modelOptions.FiscalAdj == 5
    GDP = Y_stst - FixedCost(0);
    B_stst = Params.debt2GDP * GDP;
    B = B_stst;
    B_L = B_stst;
    clear GDP;
end


if modelOptions.FiscalAdj == 6
    tauK = Params.tauK + dtau;
    tauC = Params.tauC + dtau;
    tauP = Params.tauP + dtau;
    tauP_L = Params.tauP + dtau_L;
    tauC_L = Params.tauC + dtau_L;
    tauK_L = Params.tauK + dtau_L;
else
    tauK = Params.tauK;
    tauC = Params.tauC;
    tauP = Params.tauP;
    tauP_L = Params.tauP;
    tauC_L = Params.tauC;
    tauK_L = Params.tauK;
    dtau = 0;
    dtau_L = 0;
end


if ~modelOptions.stickyPrices
    M = 1/Params.mu;
    M_L = 1/Params.mu;
    S = 1;
    ppi = 1;
end


%calculate wages and interest rates
wage =  M*(1-Params.alpha)*z* KL.^Params.alpha;
wage_L =  M_L*(1-Params.alpha)*z_L* KL_L.^Params.alpha;
rhat =  -Params.delta + M*Params.alpha*z* KL.^(Params.alpha-1);
r = (1-tauK)/(1-tauK*Params.upsilon) * rhat;

effectiveN = skill_L * N;

%Dividends
fixedCosts = FixedCost((Y-Y_stst)/Y_stst);
after_tax_div_intermed = (1-tauK)*(Y - M * z * K_L.^Params.alpha * effectiveN.^(1-Params.alpha) - fixedCosts);
revenue_from_corporate_inc_tax = tauK*(Y - M * z * K_L.^Params.alpha * effectiveN.^(1-Params.alpha) - fixedCosts) ...
    + tauK*(1-Params.upsilon)/(1-Params.upsilon*tauK)*rhat*K_L;
%for div_cap see below
dividend =  after_tax_div_intermed + div_cap - tauP*firmValue;



%income tax rates
[margtax, taxpaid] = interp_tax(x/(1+Params.nu),Params.incometax,dtau);
margtax_L = interp_tax(x_L/(1+Params.nu),Params.incometax,dtau_L);
taxpaid = taxpaid*(1+Params.nu);
margtax_stst = interp_tax(x_stst/(1+Params.nu),Params.incometax);


% some auxillary things
E = Params.nu - NLF - U;
E_L = Params.nu - NLF_L - U_L;
tmp = Params.Tu + Params.To;
transferspending_tmp = E_L*tmp(1) + U_L*tmp(2) + NLF_L*tmp(3);

if modelOptions.stickyPrices
    laborMarketStatus = Params.shockWeight(1) * log(z) - Params.shockWeight(2)*mpshock - (1-sum(Params.shockWeight))*markupshock;
else
    laborMarketStatus = Params.shockWeight(1) * log(z);
end


stocks_pred = transProb_exog([1;2;3],[1;2;3],laborMarketStatus)' * [E_L; U_L; NLF_L];



%model equations

equCount = 0;


resAgg(equCount+1) = log(z)-Params.rhoz*log(z_L)-eps(1);
equCount = equCount + 1;

if modelOptions.experiment ~= 7
    resAgg(equCount+1) = Gshock - Params.rhoG*Gshock_L -eps(2);
    equCount = equCount + 1;
end

if modelOptions.stickyPrices
    resAgg(equCount+1) = -mpshock + Params.rhomp * mpshock_L + eps(3);
    resAgg(equCount+2) = -markupshock + Params.rhomarkup * markupshock_L + eps(4);
    equCount = equCount + 2;
end


revenue_tmp = taxpaid + LumpSumTax ...
    + tauC*Ctmp + firmValue*tauP ...
    + revenue_from_corporate_inc_tax;

resAgg(equCount+1) = -B  + B_L/ppi*(1 + ii_L) + G  + transferspending_tmp - revenue_tmp; %gov budg



resAgg(equCount+2) = -U + stocks_pred(2);
resAgg(equCount+3) = -NLF + stocks_pred(3);

resAgg(equCount+4) = Klag - K_L;

nBWequ = equCount+4;



resAgg(equCount+5) = KL - K_L/effectiveN;  % def of KL
resAgg(equCount+6) = Y*S - z * K_L.^Params.alpha * effectiveN.^(1-Params.alpha);

sep = 1 + 1/Params.psi2;
resAgg(equCount+7) = -skill + ((Params.sbar^sep + Params.smeanofhhlds^sep*E)/(1+E)).^(1/sep);

resAgg(equCount+8) =  (1-margtax)/(1+tauC)*wage*skill_L*Ctmp.^(-Params.sigma) - Params.psi1 * (N/(1+E_L)).^Params.psi2;


resAgg(equCount+9) = -x + B_L*ii_L/ppi + effectiveN*wage + dividend + Params.Tu(2)*U_L;


resAgg(equCount+10) = -div_cap +  r *K_L - K + K_L - Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L;


resAgg(equCount+11) = (K + Ctmp + G) - (Y + (1-Params.delta)*K_L - FixedCost((Y-Y_stst)/Y_stst) -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L);  %agg res con
%  resAgg(equCount+11) = B + (1+Params.tauC)*Ctmp - B_L/ppi - (x - taxpaid) ...
%      + LumpSumTax - Params.To(3) * NLF_L;  % budget const


resAgg(equCount + 12) =  -K + (1-Params.delta)*K_L+Inv;        %capital update

resAgg(equCount + 13) = C - Ctmp;

equCount = equCount+13;

if modelOptions.stickyPrices
    
    resAgg(equCount+1) = -S + (1-Params.theta)*S_L*ppi.^(-Params.mu/(1-Params.mu))...
        +Params.theta*pstar.^(Params.mu/(1-Params.mu));  % price dispersion
    
    
    resAgg(equCount+2) = -ii + ii_stst + Params.phiP*(ppi-1) + Params.phiY*log(Y/Y_stst) +  mpshock;
    
    
    resAgg(equCount+3) = -ppi + ((1-Params.theta)/(1-Params.theta*pstar.^(1/(1-Params.mu)))).^(1-Params.mu);  % pi
    
    resAgg(equCount+4) = -pstar + pbarA/pbarB; %pstar
    
    equCount = equCount + 4;
    
end


if modelOptions.experiment ~= 7
    if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 1
        resAgg(equCount+1) = -G + Gshock +  G_stst * (B_L/B_stst).^Params.phiLST;  %fiscal policy rule
        equCount = equCount + 1;
    elseif modelOptions.FiscalAdj == 3
        resAgg(equCount + 1) = -G + Gshock + G_stst;
        resAgg(equCount + 2) = LumpSumTax - log((B_stst./B_L).^Params.phiLST) - LumpSumTax_stst;
        equCount = equCount + 2;
    elseif modelOptions.FiscalAdj == 4
        resAgg(equCount+1) = -log((G-Gshock)) + log(G_stst) + (-Params.phiG/Params.phiLST) * (LumpSumTax - LumpSumTax_stst);
        resAgg(equCount + 2) = LumpSumTax - log((B_stst./B_L).^Params.phiLST) - LumpSumTax_stst;
        resAgg(equCount + 3) = -revenue + revenue_tmp;
        resAgg(equCount + 4) = -transferspending  + transferspending_tmp;
        resAgg(equCount + 5) = -taxes_income + taxpaid;
        resAgg(equCount + 6) = -taxes_corp + revenue_from_corporate_inc_tax;
        resAgg(equCount + 7) = -monProf + (Y - M * z * K_L.^Params.alpha * effectiveN.^(1-Params.alpha) - fixedCosts);
        resAgg(equCount + 8) = -UI + U_L*Params.Tu(2);
        resAgg(equCount + 9) = taxes_prop - firmValue*tauP;
        equCount = equCount + 9;
        
    elseif modelOptions.FiscalAdj == 5
        resAgg(equCount+1) = -G +  G_stst + Gshock;
        equCount = equCount + 1;
        
    elseif modelOptions.FiscalAdj == 6 
        resAgg(equCount+1) =-log((G-Gshock)) + log(G_stst) + (-Params.phiG/Params.phiLST*Params.taxbase) * dtau;
        resAgg(equCount + 2) = dtau - log((B_stst./B_L).^(Params.phiLST/Params.taxbase));
        equCount = equCount + 2;
    else
        assert(modelOptions.FiscalAdj == 2)
    end
end



assert( Params.sigma == 1 )
SDF = Params.beta * Ctmp_L / Ctmp * (1+tauC_L)/(1+tauC);

taxRatio = (1-margtax)/(1-margtax_L);


resAgg(equCount +1) =  -SDF*(1 + ii_L*(1-margtax))/ppi + 1 + eta(1);  %Euler C

netI = Inv-Params.delta*K_L;
netI_L = Inv_L - Params.delta*Klag_L;

resAgg(equCount + 2) = -SDF/(1+tauP)*taxRatio*(1 + r  - (Params.Psi/2)*(netI/K_L).^2 + Params.Psi*(netI/K_L)*(K/K_L))...
    + (1+Params.Psi*(netI_L/Klag_L)) + eta(2); %euler investment

resAgg(equCount+3) = -firmValue_L*(1 + tauP_L) + div_cap_L + taxRatio*SDF * firmValue + eta(3);

equCount = equCount + 3;

if modelOptions.stickyPrices
    resAgg(equCount + 1) = -pbarB_L + Y_L*(1-tauK_L)/(1-Params.tauK) + taxRatio*SDF*(1-Params.theta)*ppi.^(-Params.mu/(1-Params.mu)-1)*pbarB +eta(4); % pbarB
    resAgg(equCount + 2) = -pbarA_L + M_L*Params.mu*Y_L*(1-tauK_L)/(1-Params.tauK) + taxRatio*SDF*(1-Params.theta)*ppi.^(-Params.mu/(1-Params.mu))*pbarA + markupshock_L +eta(5); % pbarA
    equCount = equCount + 2;
end




resid = resAgg;


if modelOptions.stickyPrices
    aggBW = 1:nBWequ;
    aggStat = nBWequ+1:equCount-5;
    aggFW = equCount-4:equCount;
else
    aggBW = 1:nBWequ;
    aggStat = nBWequ+1:equCount-3;
    aggFW = equCount-2:equCount;
end


Env.iEquBW = aggBW;
Env.iEquStat = aggStat;
Env.iEquFW = aggFW;

Env.iEquBWS = [Env.iEquBW Env.iEquStat];