
global shocks;

%% indices

iY = find(strcmp(Params.names,'Y'));
iC = find(strcmp(Params.names,'C'));
iG = find(strcmp(Params.names,'G'));
ippi = find(strcmp(Params.names,'ppi'));
iii = find(strcmp(Params.names,'ii'));
idlogY = length(G1)+1;
iK = find(strcmp(Params.names,'K'));
iB = find(strcmp(Params.names,'B'));
ilogGrossI = idlogY + 1;
ilogY = idlogY + 2;
ilogC = idlogY + 3;
ilogG = idlogY + 4;

% add d log Y as a variable to compute moments of

G1 = [G1 zeros(length(G1),1); zeros(1,length(G1)+1)];
impact = [impact; [0 0 0 0]];

G1(idlogY,:) = G1(iY,:);
G1(idlogY,iY) = G1(idlogY,iY)-1;
G1(idlogY,:) = G1(idlogY,:)./Env.stst(iY);

impact(idlogY,:) = impact(iY,:)./(Env.stst(iY)-FixedCost(0));

% add gross investment as a variable
G1 = [G1 zeros(length(G1),1); zeros(1,length(G1)+1)];
impact = [impact; [0 0 0 0]];

G1(ilogGrossI,:) = G1(iK,:);
G1(ilogGrossI,iK) = G1(iK,iK)-1+Params.delta;
G1(ilogGrossI,:) = G1(ilogGrossI,:)./(Params.delta*Env.stst(iK));

impact(ilogGrossI,:) = impact(iK,:)./(Params.delta*Env.stst(iK));


% add log Y as a variable to compute moments of

G1 = [G1 zeros(length(G1),1); zeros(1,length(G1)+1)];
impact = [impact; [0 0 0 0]];

G1(ilogY,:) = G1(iY,:);
G1(ilogY,:) = G1(ilogY,:)./Env.stst(iY);

impact(ilogY,:) = impact(iY,:)./(Env.stst(iY)-FixedCost(0));


% add log C as a variable to compute moments of

G1 = [G1 zeros(length(G1),1); zeros(1,length(G1)+1)];
impact = [impact; [0 0 0 0]];

G1(ilogC,:) = G1(iC,:);
G1(ilogC,:) = G1(ilogC,:)./Env.stst(iC);

impact(ilogC,:) = impact(iC,:)./Env.stst(iC);

% add log G as a variable to compute moments of

G1 = [G1 zeros(length(G1),1); zeros(1,length(G1)+1)];
impact = [impact; [0 0 0 0]];

G1(ilogG,:) = G1(iG,:);
G1(ilogG,:) = G1(ilogG,:)./Env.stst(iG);

impact(ilogG,:) = impact(iG,:)./Env.stst(iG);

%% compute variances 


compute_variances;
 
 %% Variance decomp
 
sumsquareirf = 0;
Gtemp = eye(size(G1));
for i = 0:1000
    sumsquareirf = sumsquareirf + (Gtemp*impact).^2;
    Gtemp = G1*Gtemp;
end
var_decomp = sumsquareirf .* (ones(length(impact),1) * diag(Params.Sigma)'.^2);

if  any(abs((sum(var_decomp,2) - diag(V0))./(diag(V0)+1e-5) > 1e-5))
    disp(num2str(abs(sum(var_decomp,2) - diag(V0))))
    error('variance decomposition does not match theoretical variance')
end

var_decomp = var_decomp./(sum(var_decomp,2) * ones(1,4));

%% Covariances and correlations
cov_dlogY_ppi = V0(idlogY,ippi);
corr_dlogY_ppi = cov_dlogY_ppi/(stdev(idlogY)*stdev(ippi));

cov_logY_ppi = V0(ilogY,ippi);
corr_logY_ppi = cov_logY_ppi/(stdev(ilogY)*stdev(ippi));

iC = find(strcmp(Params.names,'C'));
%corr_logY_C = V0(ilogY,iC)/(stdev(ilogY)*stdev(iC))
corr_logY_logC = V0(ilogY,ilogC)/(stdev(ilogY)*stdev(ilogC));

%% Compute largest autoregressive root of inflation based on AR(3)


disp('simulating')
burn = 1000;


%simulate to calculate variances 
ser = zeros(size(impact,1),Params.sim_T);

state = impact*Params.Sigma*shocks(:,1);
for t = 1:Params.sim_T
    ser(:,t) = state;
    state = G1*state + impact*Params.Sigma*shocks(:,t+1);
end

ser = bsxfun(@plus, ser(1:length(Env.stst),:), Env.stst);

ppi_sim = ser(ippi,burn+1:end)';


m.a = ARq( ppi_sim, 3 );
LARppi = max(abs(roots(m.a)));


%% print variance of unemployment rate and food stamp ratio

iU = strcmp(Params.names,'U');
iNLF = strcmp(Params.names,'NLF');
U = ser(iU, burn+1:end)';
NLF = ser(iNLF, burn+1:end)';
E = Params.nu - U - NLF;
urate = Params.nu*U./(1+Params.nu*(U+E));
SNAP = Params.nu*NLF./(1+Params.nu*(U+E));

s_urate = std(urate);
s_SNAP = std(SNAP);
disp(['std of unemployment rate = ' num2str(s_urate)])
disp(['std of SNAP ratio = ' num2str(s_SNAP)])



iz = strcmp(Params.names,'z');
imp = strcmp(Params.names,'mpshock');
imarkup = strcmp(Params.names,'markupshock');
compShock = Params.shockWeight(1) * ser(iz,burn+1:end) ...
            -Params.shockWeight(2) * ser(imp,burn+1:end) ...
            -(1-sum(Params.shockWeight)) * ser(imarkup,burn+1:end);


initialclaims = (Params.LFtransMat_ss(1,2)+Params.LFtransMat_z(1,2)*compShock)./(1-(Params.LFtransMat_ss(2,1)+Params.LFtransMat_z(2,1)*compShock));

s_initialclaims = std(100*initialclaims);


%% corporate income tax
icorp = strcmp(Params.names,'taxes_corp');
sim_taxes_corp = ser(icorp,burn+1:end);
sim_Y = ser(iY,burn+1:end);
tmp = cov(sim_Y'/Env.stst(iY), sim_taxes_corp'/Env.stst(iY));
cov_Y_tauCorp = tmp(1,2)*1000;


%% other taxes



Y = ser(iY,burn+1:end);
NetInterest = ser(strcmp(Params.names,'ii'),burn:end-1).*ser(strcmp(Params.names,'B'),burn:end-1);
B = ser(strcmp(Params.names,'B'),burn:end-1);
G = ser(strcmp(Params.names,'G'),burn+1:end);
taxes_corp = sim_taxes_corp;
taxes_income = ser(strcmp(Params.names,'taxes_income'),burn+1:end);
taxes_prop = ser(strcmp(Params.names,'taxes_prop'),burn+1:end);
C = ser(strcmp(Params.names,'C'),burn+1:end);
LST = ser(strcmp(Params.names,'LumpSumTax'),burn+1:end);

UI = ser(strcmp(Params.names,'UI'),burn+1:end);

taxes_total = taxes_income  + taxes_prop + taxes_corp + Params.tauC*C + LST;


%our_saving = taxes_total - G - 4*UI - NetInterest;
our_saving = B(2:end) - B(1:end-1);


%save tmp.mat our_saving Y taxes_total G UI NetInterest taxes_income taxes_prop taxes_corp Params C B;

%% descriptive names
vlogY = V0(ilogY,ilogY);
vppi = V0(ippi,ippi);
autocorrlogY = V1(ilogY,ilogY)/V0(ilogY,ilogY);
autocorrppi = V1(ippi,ippi)/V0(ippi,ippi);
corrlogYppi = corr_logY_ppi;
vardecomplogYz = var_decomp(ilogY,1);
vardecomplogYmp = var_decomp(ilogY,3);
varlogGrossI = V0(ilogGrossI,ilogGrossI);
stdNGS2GDP = std(our_saving./(Y(1:end-1)-FixedCost((Y(1:end-1)-Env.stst(iY))/Env.stst(iY)))); 
stdlogG = sqrt(V0(ilogG,ilogG));
autocorrii = V1(iii,iii)/V0(iii,iii);
vardecompUz = var_decomp(iU,1);
vardecompUmp = var_decomp(iU,3);


model_mom = [s_urate;
            s_SNAP;
            vlogY;
            vppi;
            vardecomplogYz;
            vardecomplogYmp;
            vardecompUz;        
            vardecompUmp;        
            autocorrlogY;
            corrlogYppi;        
            stdNGS2GDP;
            stdlogG
            cov_Y_tauCorp
            corr_logY_logC;
            LARppi;
            sqrt(varlogGrossI);
            autocorrii];

moment_names = char({'std of unemp rate', 'std of SNAP ratio','std log Y x 100','std \pi x 100',...
    'var decomp Y, z', 'var decomp Y, mp','var decomp U, z', 'var decomp U, mp',  ...
    'autocorr log Y',  'corr(log Y, \pi)',...
    'std budg def to GDP', 'std log G', 'cov(corp tax rev., Y) x1000', 'corr(Y,C)',...
    'L.A.R. \pi','StD of log I', 'autocorr ii' ...
    });