%% Names 
global Params;

Params.freq = 4;  %quartlery model
Params.seed = 2.116921967000000e+05;  % random seed for simulations


% variable names
if modelOptions.FiscalAdj == 0
    Params.names = {'z', 'Gshock', 'mpshock', 'markupshock', 'K', 'Klag', 'B', 'U', 'NLF',...
        'skill', 'KL', 'Y',  'G', 'div_cap', 'N',  'x', 'ii', 'C', 'S',  'ppi','pstar','M', ...
        'Crat', 'Inv', 'pbarA','pbarB', 'firmValue'};
elseif modelOptions.FiscalAdj == 1 || modelOptions.FiscalAdj == 5
    Params.names = {'z', 'Gshock', 'mpshock', 'markupshock', 'K', 'Klag', 'U', 'NLF', 'skill', 'LumpSumTax', 'KL', 'Y',  'G', 'div_cap', 'N',  'x', 'ii', 'C','Crat', 'Inv', 'ppi','pstar','M','pbarA','pbarB','S', 'firmValue'};
elseif modelOptions.FiscalAdj == 2
        Params.names = {'z', 'Gshock', 'mpshock', 'markupshock', 'K', 'Klag', 'U', 'NLF', 'skill', 'KL', 'Y', 'G', 'div_cap', 'N',  'x', 'ii', 'C', 'Crat',  'Inv', 'ppi','pstar','M','pbarA','pbarB','S', 'firmValue'};
elseif modelOptions.FiscalAdj == 3
    Params.names = {'z', 'Gshock', 'mpshock', 'markupshock', 'K', 'Klag', 'B',  'U', 'NLF',...
        'skill', 'LumpSumTax', 'KL', 'Y',  'G', 'div_cap', 'N', 'x','S', 'ppi','pstar',  'M', 'ii', 'C',...
        'Crat',  'Inv','pbarA','pbarB', 'firmValue'};
elseif modelOptions.FiscalAdj == 4
    Params.names = {'z', 'Gshock', 'mpshock', 'markupshock', 'K', 'Klag',...
        'B',  'U', 'NLF', 'skill', 'LumpSumTax', 'KL', 'Y',  'G', 'div_cap',...
        'N', 'x','S', 'ppi','pstar',  'M', 'ii', 'C', 'revenue', 'transferspending',...
        'taxes_income', 'taxes_corp', 'taxes_prop', 'Crat',  'Inv','pbarA','pbarB', 'firmValue','monProf','UI'};  
elseif modelOptions.FiscalAdj == 6
    Params.names = {'z', 'Gshock', 'mpshock', 'markupshock', 'K', 'Klag',...
        'B',  'U', 'NLF', 'skill', 'dtau', 'KL', 'Y',  'G', 'div_cap',...
        'N', 'x','S', 'ppi','pstar',  'M', 'ii', 'C',...
         'Crat',  'Inv','pbarA','pbarB', 'firmValue'};  
end

Params.nz = 4;

if ~modelOptions.stickyPrices
    %delete the followoing variables from the system
    delVar = {'S','M','pbarA','pbarB', 'pstar', 'ppi', 'mpshock', 'markupshock'};
   
    I = ones(size(Params.names));
    for i = 1:length(delVar)
        I = I.*(~strcmp(Params.names,delVar{i}));
    end
    I = logical(I);
    Params.names = Params.names(I);
    
    Params.nz = Params.nz - 2;
    
end


if modelOptions.experiment == 7  %no government
    Params.names = Params.names(logical( ~strcmp(Params.names,'Gshock') .* ~strcmp(Params.names,'G') ));
    Params.nz = Params.nz -1;
end

%% external calibration

%preferences
Params.sigma = 1;  %risk-aversion



%markets
Params.mu = 1.1; %CES parameter (10% markup)
Params.theta = 1/3.5; %calvo parameter (change prices every 3.5 quarters on average)

%production
Params.alpha = 1 - (1-0.36) * Params.mu;  % capital share targets capital share of 36%
Params.delta = 0.0456/4; % depreciation rate


Params.nu = 4;  %mass of households


% some taxes (others below) 
Params.tauK = 0.35;  


%steady state labor market transition probabilities
 Params.LFtransMat_ss = [   0.969425752923931   0.030574247076069                   0
   0.539801877892624   0.194832843834118   0.265365278273258
   0.087327000000000                   0   0.912673000000000];


%% These parameters are set by calibrate.m
 
Params.sbar = 3.62953982561;  % capital-owner skill level
Params.smeanofhhlds = 1.04782049852; % rep household skill-level
Params.psi1 = 5.44908344236; % labor supply parameter
Params.psi2 = 2; % labor supply parameter
taxConstant = -0.0110209580972;  % adjust intercept of income tax
Params.Tu = [0;0.148634428393;0]; % unemployment benefits
Params.To = [0;0;0.152634087868]; % other social benefits
Params.tauC = 0.0535444863237; % Consump tax
Params.tauP = 0.00258317982938; % property tax
Params.fixedCost = [0.582315624326   0]; % fixed cost of intermediate goods firms
Params.beta = 0.988830128237; % discount factor
Params.GonY = 0.145291631621; % G/Y (where Y is production not GDP.  GDP = Y - fixed costs)
Params.debt2GDP = 1.95085095677; % gov debt to GDP (divide by 4 for debt to annual GDP)
Params.upsilon = 0.679552793355; % partial deduction of capital costs


Params.betae = Params.beta;  % in one case, we call it betae in shared code

%% load the income tax
load incometax;
Params.incometax = incometax; clear incometax;

%Add a constant to tax function so that it generates aggregate income tax
%revenues.
Params.incometax.marg(end) = Params.incometax.marg(end) + taxConstant;
Params.incometax.cumul(end-1) = Params.incometax.cumul(end-1) + taxConstant;
Params.incometax.breakval = Params.incometax.breakval + taxConstant;


%% These parameters are set by calibrate_dynamics.m
%there are two cases depending on whether unemployment is exogenous or
%endogenous.



    


Params.SigmaEpsz =  0.002936169743355;  % st dev of z shock
Params.rhoz = 0.75; % persistence of z shock

Params.SigmaG = 0;
Params.rhoG = 0;

Params.Sigmatax = 0;
Params.rhotax = 0;

Params.SigmaEpsmp = 0.003533607840688; % st dev of MP shock
Params.rhomp = 0.62; % persistence


Params.Sigmamarkup = 0.025141071226995;
Params.rhomarkup = 0.85;

Params.phiLST =  -1.6;  % fiscal adjustment speed parameter
Params.phiG = 0.8*Params.phiLST;


Params.phiP = 1.55;
Params.phiY = 0.0;
Params.phii = 0.0;

Params.Psi =  6;  %capital adj cost

Params.shockWeight =  [0.639337048621449   0.317676504487140];      % 1 - sum(Params.shockWeight) is weight on markup shocks in unemployment dynamics


% labor market fluctuations
Params.LFtransMat_z = [  0    -2.812554072258800        0;
                        0  0    0;
                        2.325866859407174        0   0];   %this row is set internally (see transProb.m)


Params.LFtransMat_z = Params.LFtransMat_z + diag(zeros(3,1) - sum(Params.LFtransMat_z,2));

Params.LFtransMat_z_nonLinear = Params.LFtransMat_z./(max(Params.LFtransMat_ss,1e-10).*(1-Params.LFtransMat_ss));

% don't change this for Rep Agent economy
Params.wageTrans = 1;
    

if modelOptions.stickyPrices
    Params.Sigma = diag([Params.SigmaEpsz; Params.SigmaG; Params.SigmaEpsmp; Params.Sigmamarkup]);
elseif modelOptions.experiment ~= 7
    Params.Sigma = diag([Params.SigmaEpsz; Params.SigmaG]);
elseif modelOptions.experiment == 7    
    Params.Sigma = Params.SigmaEpsz;
end

