function [x_resid Env resid] = solveForSS(X)

    global Params modelOptions;


    x_in = X(1);
    n = X(2);
    
    if n<0
        x_resid = [0; 10];
        return;
    end
    
    margtax = interp_tax(x_in/(1+Params.nu), Params.incometax);
    margtax_track =  margtax;   

    %solve for steady state
    
    mpshock = 0; %#ok
    Gshock = 0; %#ok
    markupshock = 0; %#ok
    S = 1; %#ok
    ppi = 1; %#ok
    pstar = 1;%#ok
       
    [ z, M, wage, ii, r, rhat, KL] = SteadyStatePrices( margtax );
    YonN = KL^Params.alpha;

    
    
    
    GonN = Params.GonY * YonN;
    ConN = YonN - Params.delta*KL - GonN; % excludes fixed cost
    
    
    
    exogDist = invdistr(Params.LFtransMat_ss')*Params.nu;
    E = exogDist(1);
    U = exogDist(2);
    NLF = exogDist(3); %#ok



    sep = 1 + 1/Params.psi2;
    skill = ((Params.sbar^sep + Params.smeanofhhlds^sep*E)/(1+E))^(1/sep);

    effectiveN = skill*(1+E)*n;
    N = (1+E)*n;
    Hrs = N;
    
    C = ConN * effectiveN - FixedCost(0);
    
    ls_resid = (1-margtax)/(1+Params.tauC)*wage*skill*C^(-Params.sigma) - Params.psi1 * n^Params.psi2;
    
    

    K = KL * effectiveN;
    Y = YonN * effectiveN;
    G = GonN * effectiveN;

    
    

    pbarA = Y/(1-Params.beta*(1-Params.theta));
    pbarB = pbarA; %#ok

    
    Klag = K; %#ok
    
    
    
     %Dividends
    div_cap = r*K;
    firmValue = div_cap/(1+Params.tauP-Params.betae);
    
  
    fixedCosts = FixedCost(0);
    after_tax_div_intermed = (1-Params.tauK)*(Y - M * z * K.^Params.alpha * effectiveN.^(1-Params.alpha) - fixedCosts);
    revenue_from_corporate_inc_tax = Params.tauK*(Y - M * z * K.^Params.alpha * effectiveN.^(1-Params.alpha) - fixedCosts) ...
                                     + Params.tauK*(1-Params.upsilon)/(1-Params.upsilon*Params.tauK)*rhat*K;


    dividend =  after_tax_div_intermed + div_cap - Params.tauP*firmValue;
  
    
    GDP = Y - fixedCosts;
    B = Params.debt2GDP * GDP;
    
    
    
    x =  ii * B + wage*effectiveN + dividend + dot(Params.Tu,[0;U;0]);
      
    x_resid = [x-x_in; ls_resid];
    if nargout == 1, return; end
    
    [~, taxpaid] = interp_tax(x/(1+Params.nu), Params.incometax);
    taxpaid = taxpaid*(1+Params.nu);
    
    
    
    
    transferspending = dot(exogDist,Params.To+Params.Tu);
    UI = exogDist(2)*Params.Tu(2);
    

   %test market clearing
   %disp('test market clearing:')
   %abs(C-(x + NLF * Params.To(3)  - taxpaid - Params.tauC*C)) 
   

    revenue = taxpaid + Params.tauC*C...
         + firmValue*Params.tauP + revenue_from_corporate_inc_tax;
     

    expenditure = G + B*ii + transferspending;
     
%     taxpaid2gdp = taxpaid / GDP
%     constax2gdp = (Params.tauC*C)/ GDP
%     proptax2gdp = (firmValue*Params.tauP)/GDP
%     corptax2gdp = revenue_from_corporate_inc_tax / GDP
%     exp2gdp = expenditure / GDP
%     rev2gdp = revenue / GDP
    
    netInterestExpense = B*ii/GDP;

    LumpSumTax = expenditure - revenue;
    revenue = revenue + LumpSumTax;
    taxes_income = taxpaid;
    taxes_corp = revenue_from_corporate_inc_tax;
    taxes_prop = firmValue*Params.tauP;
    monProf = (Y - M * z * K.^Params.alpha * effectiveN.^(1-Params.alpha) - fixedCosts);
        
    if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 2 || modelOptions.FiscalAdj == 6
        Params.LumpSumTax = LumpSumTax;
    end

    if modelOptions.FiscalAdj == 6
        dtau = 0;
        Params.taxbase = x*(1+Params.nu) + taxes_corp/Params.tauK + taxes_prop/Params.tauP + C;
    end
  
    Crat = C/(Y-G-FixedCost(0));
    

    %investment
    Inv = Params.delta*K/(Y-G-FixedCost(0));
       
    %package results
    for nm_i = 1:length(Params.names)
        eval(['Env.stst(nm_i) = ' Params.names{nm_i} ';']) 
    end

    Env.stst = Env.stst'; %#ok

    %Below here is for calibration 
    if nargout < 3, return; end


    
    fixedCosts = FixedCost(0);
    div_intermed = Y - M * z * K.^Params.alpha * effectiveN.^(1-Params.alpha) - fixedCosts...
        + Params.tauK*(1-Params.upsilon)/(1-Params.upsilon*Params.tauK)*rhat*K;
    r = (1-Params.upsilon*Params.tauK)/(1-Params.tauK)*rhat;
    corpProf = div_intermed + (1-Params.upsilon)*r*K;
    
    corp_inc_tax_rev = Params.tauK*(Y *(1- M) - fixedCosts) ...
        + Params.tauK*(1-Params.upsilon)/(1-Params.upsilon*Params.tauK)*rhat*K;


    
    
    resid = [n-0.31;  %average hours
            x-(1+Params.nu); %average income
            taxpaid/GDP-0.10976; %income tax revenue
            Params.Tu(2)-0.003352 * GDP/U; %average expenditure on transfers
            Params.To(3)-0.01046*GDP/NLF; % "
            Params.tauC-0.03847*GDP/C; %consumption tax revenue
            firmValue*Params.tauP/GDP - 0.02790;  %revenue raised from property tax
            K/GDP - 4*2.67; %cap-output ratio
            G/GDP - 0.15978;  %G / GDP
            netInterestExpense - 0.02825; % government's net interest expense to GDP
            corpProf/GDP - 0.09132945;  %corporate profits to GDP
            corp_inc_tax_rev/GDP - 0.02572];  

end
