clear all; close all; clc;


% an experiment is described by:
% 1) experiment change in parameters (e.g. low transfers vs high transfers)
% 2) fiscal adjustment rule (gammaG and gammaT)
% 3) search friction?  
% 4) sticky prices?  (no = benchmark for output gap with pi = 1, markup constant)
% 5) robustness change in parameters (e.g. high labor supply elasticity)

main_list = {{0 3 0 1 0}, {4 3 0 1 0},{2 3 0 1 0},{3 3 0 1 0},...
{6 3 0 1 0},{0 4 0 1 0},{1 4 0 1 0}};

deficit_list = {{1 3 0 1 0},{0 5 0 1 0}, {1 5 0 1 0},{0 6 0 1 0}, {1 6 0 1 0}};

monpol_list = {{0 4 0 1 12},{1 4 0 1 12},{0 4 0 1 3},{1 4 0 1 3},{0 4 0 1 14},...
    {1 4 0 1 14},{0 4 0 1 7},{1 4 0 1 7},{0 4 0 1 10},{1 4 0 1 10}};


batch_projName = 'FullModel';
batch_experiment_list = [main_list deficit_list monpol_list];


setpath(batch_projName);

for batch_i = 1:length(batch_experiment_list)
    clearvars -except batch*
    exp_in = batch_experiment_list{batch_i}{1};
    fa_in = batch_experiment_list{batch_i}{2};
    search_in = logical(batch_experiment_list{batch_i}{3});
    sticky_in = logical(batch_experiment_list{batch_i}{4});
    robust_in = batch_experiment_list{batch_i}{5};
    eval([batch_projName ';']);
end

batch_projName = 'RepAgent';
batch_experiment_list = main_list;


setpath(batch_projName);

for batch_i = 1:length(batch_experiment_list)
    clearvars -except batch*
    exp_in = batch_experiment_list{batch_i}{1};
    fa_in = batch_experiment_list{batch_i}{2};
    search_in = logical(batch_experiment_list{batch_i}{3});
    sticky_in = logical(batch_experiment_list{batch_i}{4});
    robust_in = batch_experiment_list{batch_i}{5};
    eval([batch_projName ';']);
end


batch_projName = 'HandToMouth';
batch_experiment_list = main_list;


setpath(batch_projName);

for batch_i = 1:length(batch_experiment_list)
    clearvars -except batch*
    exp_in = batch_experiment_list{batch_i}{1};
    fa_in = batch_experiment_list{batch_i}{2};
    search_in = logical(batch_experiment_list{batch_i}{3});
    sticky_in = logical(batch_experiment_list{batch_i}{4});
    robust_in = batch_experiment_list{batch_i}{5};
    eval([batch_projName ';']);
end
