function setpath(projName)
% Prepare the matlab path to solve model X where X can be:
% FullModel, RepAgent or HandToMouth



if nargin == 0
    error('You must supply a model name to setpath function.  This can be FullModel, RepAgent or HandToMouth');
else 
    proj = projName
end



fs = filesep;
p_ = pwd;


%cleanup path from previous runs
pt_ = path;

x = [p_ fs 'FullModel'];
if ~isempty(strfind(pt_,x)), rmpath(x); end

x = [p_ fs 'RepAgent'];
if ~isempty(strfind(pt_,x)), rmpath(x); end

x = [p_ fs 'HandToMouth'];
if ~isempty(strfind(pt_,x)), rmpath(x); end
    
x = [p_ fs 'CompMkts'];
if ~isempty(strfind(pt_,x)), rmpath(x); end    

x = [p_ fs 'FullModel_ISTC'];
if ~isempty(strfind(pt_,x)), rmpath(x); end

x = [p_ fs 'FullModel_Payroll'];
if ~isempty(strfind(pt_,x)), rmpath(x); end

x = [p_ fs 'RepAgent_ISTC'];
if ~isempty(strfind(pt_,x)), rmpath(x); end


addpath(p_);





% libraries:
addpath([p_ '/share/MirandaFackler']);
addpath([p_ '/share/Reiter/appraggr']);
addpath([p_ '/share/Reiter/appraggr/libaa']);
addpath([p_ '/share/Reiter/appraggr/rrqr']);
addpath([p_ '/share/Reiter/appraggr/libm']);
addpath([p_ '/share/Lengwiler']);
addpath([p_ '/share/dynare']);
addpath([p_ '/transitions']);
addpath([p_ '/share/McKayReis']);
addpath([p_ '/' proj]);
clear aadir proj;


    
% to allow loading of gramian objects
a = gramian(0.5,0.5,100,1e-14); clear a;  



end