function [ m ] = ARq( Y, q )
%ARQ fits an AR(q) to data in Y.
% returns m where m(1)y(t) + m(2) y(t-1) + ... = eps(t)

assert(size(Y,2) == 1)

YY = Y(q+1:end);

X = ones(size(YY));
for i = 1:q
    X = [X Y(q+1-i:end-i)];
end

m = (X'*X)\(X'*YY);

m = [1 -1*m(2:end)'];


end

