function [ z, M, wage, ii, r, rhat, KL] = SteadyStatePrices( margtaxe )
% [ z, M, wage, ii, r, rhat] = SteadyStatePrices( margtaxe )
% compute steady state prices

global Params;


z = 1;
M = 1/Params.mu;
r = (1+Params.tauP)/Params.betae - 1;  
rhat = (1-Params.upsilon*Params.tauK)/(1-Params.tauK) * r;
KL = ((rhat + Params.delta)/(M*Params.alpha*z))^(1/(Params.alpha-1));
wage =  M*(1-Params.alpha)*z* KL.^Params.alpha;
ii = (1/Params.betae - 1)/(1-margtaxe);

end

