function avinc = average_income(pvec,par,ip, wage, r)
% computes the average income of households with type ip
% Inputs:
%   pvec:  vector of probabilities (histogram weights)
%   par: policy rule parameters
%   ip: discret type to condition on

    global Params;
    

    ndk = Params.ndstst;
    par = par2wide(par);


    N = nspline(par(Params.par_nind,ip));

    prod_scale = Params.skill(ip);

    nsup = interp_nspline(N,Params.knotDistrK,true) * prod_scale;

    k = Params.knotDistrK;
    offs = (ip-1)*ndk;
    
    avinc = sum(pvec(offs+1:offs+ndk) .* (nsup * wage + r * k));
    avinc = avinc/sum(pvec(offs+1:offs+ndk));