
if size(G1,1) > 100
    error('G1 is too large for compute_variances.  Use simulation instead.')
    %note: I have not determined the largest system for which
    %compute_variances will work in a reasonable amount of time. 100 is
    %used as a rough guess because we either have systems with fewer than
    %50 or large systems with many more than 100.
end

 shock_var = Params.Sigma^2;

 V0 = lyapunov_symm(G1,impact* shock_var *impact',1e-10,1e-10);
 V1 = G1*V0;
 stdev = sqrt(diag(V0));
 autocorr1 = diag(V1)./diag(V0);
