
if size(A_MPA,1) > 1000
    error('A_MPA is too large for compute_variances.  Use simulation instead.')
    %note: I have not determined the largest system for which
    %compute_variances will work in a reasonable amount of time. 1000 is
    %used as a rough guess of what is feasible.
end

 shock_var = Params.Sigma^2;
 
 V0_MPA = lyapunov_symm(A_MPA,B_MPA * shock_var *B_MPA',1e-10,1e-10);
 V1_MPA = A_MPA*V0_MPA;
 
 V0_MPA = H_MPA * V0_MPA *H_MPA';
 V1_MPA = H_MPA * V1_MPA *H_MPA';
 
 
 MPA_index = find(sum(abs(H_MPA*H_MPA'))>1e-6);
 if isfield(Env,'iVarAggr')
    MPA_index = intersect(MPA_index,Env.iVarAggr);
 end
 
 V0_MPA = V0_MPA(MPA_index,MPA_index);
 V1_MPA = V1_MPA(MPA_index,MPA_index);