% [EC Emargtax Etaxpaid] = expect_C(pvec,par,R,wage)
% Computes the aggregate consumption and taxes of households
% Inputs:
%   pvec:  vector of probabilities (histogram weights)
%   par: policy rule parameters
%   R: interest rate
%   wage
%   disc: vector of discrete states levels over which to integrate
%
% Alisdair McKay 2/24/12

function [EC, Emargtax, Etaxpaid, varlogc] = expect_C(pvec,par,R,wage,disc,taxshock)

  global Params;

  
  if ~exist('taxshock','var')
      taxshock = 0;
  end
  if ~exist('disc','var')
      disc = [];
  end
  
  npp = Params.npp;
  par = par2wide(par);
  
  ndk = Params.ndstst;
  
  EC = 0;
  varlogc = 0;
  Elogc = 0;
  Etaxpaid = 0;
  Emargtax = 0;
  
  if isempty(disc)  % use all skill levels
      dgrid = 1:npp;
  else
      dgrid = disc;
  end
  
    
  %loop over discrete grid
  for ip=dgrid
      S = savingspline(par(Params.par_sind,ip));
      N = nspline(par(Params.par_nind,ip));
    
      %we have end of period assets in last period and this period,
      %and we have to figure out this period's consumption:
      xthis = Params.knotDistrK;
      sthis = interp_savspline(S,xthis);
      [c, ~, margtax, taxpaid] = get_cnt(xthis,sthis,N,R,wage,ip,taxshock);
  
      
      
      %build up expectation
      offs = (ip-1)*ndk;
           
      EC = EC + sum(pvec(offs+1:offs+ndk) .* c);
      Etaxpaid = Etaxpaid + sum(pvec(offs+1:offs+ndk) .* taxpaid);
      Emargtax = Emargtax + sum(pvec(offs+1:offs+ndk) .* margtax);

      
      if nargout >= 4
          Elogc = Elogc + sum(pvec(offs+1:offs+ndk) .* log(c));
          varlogc = varlogc + sum(pvec(offs+1:offs+ndk) .* log(c).^2);
      end
  end
  
  varlogc = varlogc - Elogc^2;

      
  
end
