
% Computes the average job-finding rate among unemployed,
% Inputs:
%   pvec:  vector of probabilities (histogram weights)
%   par: policy rule parameters


function jobfindingrate = expect_jobfind(pvec,par,logLMshock)
  global Params;
  
  ndk = Params.ndstst;
  
  U = 0;
  jfinders = 0;
  
  for ip=1:Params.npp
      if Params.estatus(ip) == 2
        N = nspline(par(Params.par_nind,ip));
      
     
        nsup = interp_nspline(N,Params.knotDistrK,true);
        jfr  = transProb(2,1,logLMshock,nsup);
        
        offs = (ip-1)*ndk;
        U = U + sum(pvec(offs+1:offs+ndk));
        jfinders = jfinders + sum(pvec(offs+1:offs+ndk) .* jfr);
        
      end
  end
  
  assert(ip*ndk == length(pvec));
      
  jobfindingrate = jfinders/U;
