function [prob dprobdn] = transProb_endog(i,j,logLMshock,n)
%Computes the probability of moving from state i to state j when exogenous
%aggregate state is logLMshock and search effort is given by vector n

assert(length(i) == 1, 'error in transProb: i should be integer scalar.')
assert(length(j) == 1, 'error in transProb: j should be integer scalar.')


    global Params;

    
    si = Params.sstatus(i);
    sj = Params.sstatus(j);
    ei = Params.estatus(i);
    ej = Params.estatus(j);
    
    assert(ei >= 1 && ej <= 3, 'error in transprob: ei and ej should be in 1,2 3')
    
    
    STrans = Params.wageTrans( si, sj);
    
    ETrans = 0;
    dprobdn = 0;
    
    if ei == 2
        pbar = Params.LF.ss.USearchEff;
        p = 1 - exp(-pbar*n);
        dp = pbar * exp(-pbar*n);
        if ej == 1
            ETrans = p;
            dprobdn = dp;
        elseif ej == 2;
            pi2 = Params.LF.ss.UNProb + Params.LF.z.UNProb * logLMshock;
            ETrans = (1-p) * (1-pi2);
            dprobdn = -dp * (1-pi2);
        else 
            pi2 = Params.LF.ss.UNProb + Params.LF.z.UNProb * logLMshock;
            ETrans = (1-p) * pi2;
            dprobdn = -dp * pi2;
        end
    elseif ei == 3
        qbar = Params.LF.ss.NSearchEff + Params.LF.z.NSearchEff * logLMshock;
        q = 1 - exp(-qbar*n);
        dq = qbar * exp(-qbar*n);
        if ej == 1
            ETrans = q;
            dprobdn = dq;
        elseif ej == 3;
            ETrans = 1-q;
            dprobdn = -dq;
        end
    else
        JobLoss = Params.LF.ss.JobLoss + Params.LF.z.JobLoss * logLMshock;
        if ej == 1
            ETrans = (1-JobLoss)*ones(size(n));
            dprobdn = zeros(size(n));
        elseif ej == 2;
            ETrans = JobLoss*ones(size(n));
            dprobdn = zeros(size(n));
        end
    end
    

   prob = STrans * ETrans;
   
   
end

