function prob = transProb_exog(i,j,logLMshock)
%Computes the probability of moving from state i to state j when exogenous
%aggregate state is logLMshock


    global Params;
    
    %T = Params.LFtransMat_ss + Params.LFtransMat_z * logLMshock;
    %T = kron(T, Params.wageTrans);
    
    % this is the same as above, but it does not involve passing logLMshock
    % (type deriv1) through kron.
    assert(all(size(logLMshock) == 1))
    T = kron(Params.LFtransMat_ss,Params.wageTrans) ...
        + kron(Params.LFtransMat_z,Params.wageTrans) * logLMshock;
    
    if isempty(i) && isempty(j)
        prob = T;
    else
        prob = T(i,j);
    end
    

end

