function prob = transProb_nonLinear(i,j,logLMshock)
%Computes the probability of moving from state i to state j when exogenous
%aggregate state is logLMshock


    global Params;
    
    T = logistic(invlogistic(max(Params.LFtransMat_ss,1e-10)) + Params.LFtransMat_z_nonLinear * logLMshock);
    T = kron(T, Params.wageTrans);
    
    
    if isempty(i) && isempty(j)
        prob = T;
    else
        prob = T(i,j);
    end
    

end

