% Matlab file for_ paper 
% "Approximate and Almost-Exact Aggregation in Dynamic Stochastic Heterogeneous-Agent Models"
% Michael Reiter, IHS, December 2009
% Last update: -
% Feel free to use, copy and modify at your own risk;
%   this program comes with NO WARRANTY WHATSOEVER
%
% Matlab file to implement class "deriv1",
% forward mode of automatic differentation, first derivatives, possibly ssparse
% Usage:
% 1) x = deriv1(val): val is column vector
%    x is vector of independent variables, Jacobian is the identity
% 2) x = deriv1(val,iIndep): val is column vector, iIndep index of variables
%    x is vector where iIndep are independent variables, rest are constants
% 3) x = deriv1(val,0,np): val any matrix, np positive integer
%    x has zero Jacobian, assuming np independent variables
% 4) x = deriv1(val,[],J): val any matrix, J the Jacobian
%    x is matrix of values with Jacobian J
function s= deriv1(val,iIndep,deriv)
  nSparse = 1;
  if(nargin==0 | nargin>3)
    error('usage: deriv1(Value,Derivative)');
  end
  s.v=val; 
  if nargin==3
    if(isscalar(iIndep) && iIndep==0)
      np = deriv;
      if(np>=nSparse)
	s.d = ssparse(prod(size(val)),np);
      else
	s.d = zeros(prod(size(val)),np);
      end
    else
      s.d=ssparse(deriv);
    end
  else % only one argument
    m=size(val);
    if(length(m)~=2 | m(2)~=1)
      error('single argument to deriv1 must be column vector (independent variables)');
    end
    if(nargin==1)
      iIndep = 1:m(1);
    end
    nIndep = length(iIndep);
    if(nIndep>=nSparse | issparse(val))
      s.d=ssparse(iIndep,1:nIndep,ones(nIndep,1),m(1),nIndep);
    else
      s.d=zeros(m(1),nIndep);
      s.d(iIndep,:)=eye(nIndep);
    end
  end
  s=class(s,'deriv1');
