% Produces a table with calibration details
% must set path for FullModel

close all; clear all;

NUMBER_OF_DIGITS = 3;

fname = 'tex_output/table_calibtex.tex';


%Load parameters
modelOptions.experiment = 0;
modelOptions.FiscalAdj = 4;
modelOptions.search = false;
modelOptions.stickyPrices = true;
modelOptions.robustness = 0;

run('../FullModel/parameters/initparams.m')

%------

DIR_FOR_OUTPUT = 'tex_output';


%------
%read input file
A = fileread('tex_input/table_calibtex.tex');
fileread_info = regexp(A, '\n');

% replace data with updated values
Aout = '';
for i = 1:length(fileread_info)+1

    if i == 1
        I = 1:fileread_info(1);
    elseif i <= length(fileread_info)
        I = fileread_info(i-1)+1:fileread_info(i);
    else
        I = fileread_info(end)+1:length(A);
    end
        
    s = A(I);
    jk = strfind(s,'##');
    if ~isempty(jk)
        if ~all(size(jk) == [1 2])
            error('there should be two occurences of ## per line (or none)');
        end
        j = jk(1)+2;
        k = jk(2)-1;
        assert(k>j+1);
        parname = s(j:k);
        j = jk(1)-1;
        k = jk(2)+2;
        eval(['parval = ' parname ';']); 
        s = [s(1:j) num2str(parval,NUMBER_OF_DIGITS) s(k:end)];
    
    end
    Aout = [Aout s];
end
    

           
% write the tex file
fid = fopen(fname,'w');
fprintf(fid, Aout);
fclose(fid);
        


