
clear all; close all; clc;

global dirPref dirSuf NUMBER_OF_DIGITS DIR_FOR_OUTPUT DIR_FOR_INPUT;

NUMBER_OF_DIGITS = 4;

%------

DIR_FOR_OUTPUT = 'tex_output/';
DIR_FOR_INPUT = 'tex_input/';

%------
%add path for helper functions and classes
addpath('supporting_m_files')

%------

p = pwd;
i = find(p == '/',1,'last');
dirPref = p(1:i);

dirSuf = '/results';
%----

varnms = {'Y', 'Hrs', 'C', 'ppi'};

%% Transfers table

baselineID = [0 3 0 1 0];
experID = [4 3 0 1 0];

caption = 'The effect of transfers on the business cycle.';
fname_out = 'table_transfers.tex';
fname_in = 'table_exper.tex';
d = dat_4_exper_table( baselineID, experID, varnms );
writeTable(d, caption, fname_in,  fname_out)


%% Proportional taxes table

baselineID = [0 3 0 1 0];
experID = [2 3 0 1 0];
caption = 'The effect of proportional taxes on the business cycle.';
fname_out = 'table_prop_tax.tex';
fname_in = 'table_exper.tex';

d = dat_4_exper_table( baselineID, experID, varnms );
writeTable(d, caption, fname_in,  fname_out)



%% prog tax table ------

baselineID = [0 3 0 1 0];
experID = [3 3 0 1 0];
caption = 'The effect of progressive taxes on the business cycle.';
fname_out = 'table_progressive.tex';
fname_in = 'table_exper.tex';

d = dat_4_exper_table( baselineID, experID, varnms );
writeTable(d, caption, fname_in,  fname_out)



%% income tax cut stabilizer table------

baselineID = [0 3 0 1 0];
experID = [6 3 0 1 0];
caption = 'The effect of the level of tax rates on the business cycle.';
fname_out = 'table_taxcut.tex';
fname_in = 'table_exper.tex';

d = dat_4_exper_table( baselineID, experID, varnms );
writeTable(d, caption, fname_in,  fname_out)



%% all stabilizer table------

baselineID = [0 4 0 1 0];
experID = [1 4 0 1 0];
caption = 'The effect of all stabilizers on the business cycle.';
fname_out = 'table_all.tex';
fname_in = 'table_exper.tex';

d = dat_4_exper_table( baselineID, experID, varnms );
writeTable(d, caption, fname_in,  fname_out)

fname_out = ['welfare_results/experiment_' num2str(experID(1)) '_FiscalAdj_' num2str(experID(2)) '_search_' num2str(experID(3)) '_sticky_' num2str(experID(4)) '_robustness_' num2str(experID(5)) '.tex'];
[dwe, iwTable, waTable, utilitarian, betah] = dwelfare(baselineID, experID , true);
str  = table2latex( iwTable, 'Welfare comparison across steady states w/o shocks', 3 );
fid = fopen(fname_out,'w');
fprintf(fid, str);
fclose(fid);


%% deficits


baselineID = [0 4 0 1 0];
experID_1 = [0 3 0 1 0];
experID_2 = [0 5 0 1 0];
caption = 'The effect of budget deficits on variances.';
fname_out = 'table_deficits.tex';
fname_in = 'table_deficits.tex';


d = {genColumn( 'FullModel', [0 4 0 1 0], [1 4 0 1 0], varnms ),...
     genColumn( 'FullModel', [0 3 0 1 0], [1 3 0 1 0], varnms ),...
     genColumn( 'FullModel', [0 5 0 1 0], [1 5 0 1 0], varnms ),...
     genColumn( 'FullModel', [0 6 0 1 0], [1 6 0 1 0], varnms )};


writeTable(d, caption, fname_in,  fname_out)



%% monetary policy robustness


baselineID_1 = [0 4 0 1 12]; %flex price
experID_1 =    [1 4 0 1 12];

baselineID_2 = [0 4 0 1 3]; % SGU
experID_2 =    [1 4 0 1 3];

baselineID_3 = [0 4 0 1 0];  %baseline Taylor
experID_3 =    [1 4 0 1 0];


baselineID_4 = [0 4 0 1 14]; % output Taylor Params.phiY = 0.125;
experID_4 =    [1 4 0 1 14];

baselineID_5 = [0 4 0 1 7];  % aggressive Taylor Params.phiP = 1.75;
experID_5 =    [1 4 0 1 7];

baselineID_6 = [0 4 0 1 10]; % accomodative Taylor Params.phiP = 1.03;
experID_6 =    [1 4 0 1 10];




caption = 'The effect of all stabilizers on the business cycle.';
fname_out = 'table_monPolRobustness.tex';
fname_in = 'table_monPolRobustness.tex';


d = {genColumn( 'FullModel', baselineID_1, experID_1, varnms ),...
    genColumn( 'FullModel', baselineID_2, experID_2, varnms ),...
    genColumn( 'FullModel', baselineID_3, experID_3, varnms ),...
    genColumn( 'FullModel', baselineID_4, experID_4, varnms ),...
    genColumn( 'FullModel', baselineID_5, experID_5, varnms ),...
    genColumn( 'FullModel', baselineID_6, experID_6, varnms )};


writeTable(d, caption, fname_in,  fname_out)



