% Produces a table with model and data moments
% must set path for FullModel

global dirPref dirSuf;

p = pwd; 
currentDirName = p(max(strfind(p,'/'))+1:end);


if exist('transProb') == 0
    cd ..;
    setpath('FullModel')
    cd tables;
end

NUMBER_OF_DIGITS = 2;
sform = ['%0.' num2str(NUMBER_OF_DIGITS) 'f'];

fname_tex_out = 'tex_output/table_modelmoments.tex';
fname_tex_in = 'tex_input/table_modelmoments.tex';


%Load parameters and results
modelOptions.experiment = 0;
modelOptions.FiscalAdj = 4;
modelOptions.search = false;
modelOptions.stickyPrices = true;
modelOptions.robustness = 0;

run('../FullModel/parameters/initparams.m')



fname = [dirPref 'FullModel' dirSuf '/experiment_' num2str(modelOptions.experiment) '_FiscalAdj_' num2str(modelOptions.FiscalAdj) '_search_' num2str(modelOptions.search)  '_sticky_' num2str(modelOptions.stickyPrices) '_robustness_' num2str(modelOptions.robustness) '.mat'];

load(fname);
clear fname;

%rename 
mm = exact_soln.modelmoments;


%% read input file
A = fileread(fname_tex_in);
fileread_info = regexp(A, '\n');

% replace data with updated values
Aout = '';
for i = 1:length(fileread_info)+1

    if i == 1
        I = 1:fileread_info(1);
    elseif i <= length(fileread_info)
        I = fileread_info(i-1)+1:fileread_info(i);
    else
        I = fileread_info(end)+1:length(A);
    end
        
    s = A(I);
    jk = strfind(s,'##');
    if ~isempty(jk)
        if ~all(size(jk) == [1 2])
            error('there should be two occurences of ## per line (or none)');
        end
        j = jk(1)+2;
        k = jk(2)-1;
        assert(k>j+1);
        parname = s(j:k);
        j = jk(1)-1;
        k = jk(2)+2;
        eval(['parval = ' parname ';']); 
        s = [s(1:j) sprintf(sform,parval) s(k:end)];
    
    end
    Aout = [Aout s];
end
    

           
% write the tex file
fid = fopen(fname_tex_out,'w');
fprintf(fid, Aout);
fclose(fid);
        


