function [dwe, iwTable, waTable, utilitarian, betah] = dwelfare( IDbaseline, IDexperiment , stst)
% dwelfare  -- computes the change in welfare from experiment



global Params modelOptions;

modelOptions.experiment = IDbaseline(1);
modelOptions.FiscalAdj = IDbaseline(2);
modelOptions.search = IDbaseline(3);
modelOptions.stickyPrices = IDbaseline(4);
modelOptions.robustness = IDbaseline(5);


%set the baseline parameters
if ~modelOptions.search
    run('../FullModel/parameters/initparams');
else
    run('../FullModel/parameters/initparams_search');
end


%modify the parameters as per the experiments
if modelOptions.experiment > 0
    fname = [Params.dirpath '/parameters/exper_' num2str(modelOptions.experiment)];
    run(fname);
    clear fname;
end
%modify the parameters as per the robustness exercise
if modelOptions.robustness > 0
    fname = [Params.dirpath '/parameters/robustness_' num2str(modelOptions.robustness)];
    run(fname);
    clear fname;
end


clear modelOptions;

betah = Params.betah;

% load baseline and experiment data
[V,ve,baseline_stst] = loadVD(IDbaseline,stst);
[Vhat,vehat,exp_stst] = loadVD(IDexperiment,stst);


% 
% %compute change in welfare for each node
dw = exp((1-Params.betah)*(Vhat - V)) - 1;
dwe = exp((1-Params.betae)*(vehat - ve)) - 1;


% Make table over ip and wealth
wealthPcts = [0.1 0.25 0.5 0.75 0.9 1];
tabData = tableLookup(V,baseline_stst.D,wealthPcts);
tabDatahat = tableLookup(Vhat,baseline_stst.D,wealthPcts);
dtabData = exp((1-Params.betah)*(tabDatahat-tabData))-1;

iwTable = table(Params.estatus',Params.sstatus','VariableNames',{'employment', 'skill'});
for iwealth = 1:length(wealthPcts)
    iwTable = [iwTable table(dtabData(:,iwealth),'VariableNames',{['w' num2str(100*wealthPcts(iwealth))]})];
end




%average impact by income type
wadat = zeros(Params.npp,1);
wadat2 = zeros(Params.npp,1);
for ip = 1:Params.npp
    mask = false(1,Params.npp);
    mask(ip) = true;
    wadat(ip) = exp((1-Params.betah)*(weightedAverage(Vhat,exp_stst.D,mask)-weightedAverage(V,baseline_stst.D,mask)))-1;
    wadat2(ip) = exp((1-Params.betah)*(weightedAverage(Vhat,baseline_stst.D,mask)-weightedAverage(V,baseline_stst.D,mask)))-1;
end
waTable = table(Params.estatus',Params.sstatus',sum(baseline_stst.D)',wadat,wadat2,'VariableNames',{'employment', 'skill','mass','AvgOpt1','AvgOpt2'});


%Utilitarian
utildat = zeros(2,4);
utildat(1,1) = (weightedAverage(V,baseline_stst.D)*Params.nu + ve)/(1+Params.nu);
utildat(1,2) = (weightedAverage(Vhat,exp_stst.D)*Params.nu + vehat)/(1+Params.nu);
utildat(1,3) = exp((1-Params.betah)*(utildat(1,2) - utildat(1,1)))-1;
utildat(1,4) = exp((1-Params.betah)*(weightedAverage(Vhat,exp_stst.D) - weightedAverage(V,baseline_stst.D)))-1;

utildat(2,1) = (weightedAverage(V,baseline_stst.D)*Params.nu + ve)/(1+Params.nu);
utildat(2,2) = (weightedAverage(Vhat,baseline_stst.D)*Params.nu + vehat)/(1+Params.nu);
utildat(2,3) = exp((1-Params.betah)*(utildat(2,2) - utildat(2,1)))-1;
utildat(2,4) = exp((1-Params.betah)*(weightedAverage(Vhat,baseline_stst.D) - weightedAverage(V,baseline_stst.D)))-1;

utilitarian = table([1:2]',utildat(:,1),utildat(:,2),utildat(:,3),utildat(:,4),'VariableNames',{'AvgOption', 'AvgUtilsBefore', 'AvgUtilsAfter', 'dChangeConsEquiv', 'dChangeConsEquivJustImpat'});



end


function [V,ve,stst_soln] = loadVD(ID,stst)
%loads the data from disk and interpolates onto a finer grid (ie the grid
%for assets)

global dirPref dirSuf Params;

fname = [dirPref 'FullModel' dirSuf '/experiment_' num2str(ID(1))...
    '_FiscalAdj_' num2str(ID(2)) ...
    '_search_' num2str(ID(3))  ...
    '_sticky_' num2str(ID(4)) ...
    '_robustness_' num2str(ID(5)) '.mat'];
load(fname)


soln = exact_soln;

if stst 
    vpar = soln.ststvpar;
    ve = soln.ststve;    
else
    vpar = soln.Evpar;
    ve = soln.Eve;
end

% interpolate vpar onto knotdistk
npp = Params.npp;
V = zeros(length(stst_soln.wealth),npp);
for ip = 1:npp
    Vsp = vspline(vpar(:,ip));
    V(:,ip) = interp_vspline(Vsp,stst_soln.wealth);
end



stst_soln.D = reshape(stst_soln.D(:),Params.ndstst,Params.npp);

end


function tabData = tableLookup(V,D,wealthPcts)
%looks up percentiles in wealthPcts in D and reports corresponding V.
%do it for each ip in 1 to Params.npp
%result is matrix of dimension Params.npp by length(wealthPcts)


global Params;

% Make table over ip and wealth
V = reshape(V(:),Params.ndstst,Params.npp);

D = bsxfun(@rdivide,D,sum(D)); %normalize within each discrete type
D = cumsum(D);



tabData = zeros(Params.npp,length(wealthPcts));
for iwealth = 1:length(wealthPcts)
    for ip = 1:Params.npp
        wealth_ind = lookup(D(:,ip),wealthPcts(iwealth),3);
        tabData(ip,iwealth) = V(wealth_ind,ip);
    end
end


end


function wa = weightedAverage(x,w,mask)
%takes average of x weighted by w over sub-matrix specified by mask, which
%should be logical of either dimension or 2D.

assert(all(size(x) == size(w)))

if ~exist('mask','var')
    wa = dot(x(:),w(:));
    return
end

%check if mask conforms to x
[n, m] = size(mask);
if n >1 && m>1
    assert(all(size(x) == size(mask)))
    mask_ind = 0;
elseif n == 1
    assert(m == size(x,2))
    mask_ind = 2;
elseif m == 1
    assert(n == size(x,1))
    mask_ind = 1;
else
    error('unrecognized shape of mask.  one dimension is probably zero')
end

if mask_ind == 0
    tmp_x = x(mask);
    tmp_w = w(mask);
elseif mask_ind == 1
    tmp_x = x(mask,:);
    tmp_w = w(mask,:);
else
    %mask_ind == 2
    tmp_x = x(:,mask);
    tmp_w = w(:,mask);
end
    
wa = dot(tmp_x(:),tmp_w(:))/sum(tmp_w(:));


end