function [ mnogaps, varogaps, VarLogLaborWedge ] = getoutputgaps( modelID, ID )
%returns mean and variance of output gap computed relative to 1) flex price
%economy, 2) flex price economy w/o govt

global dirPref dirSuf;

%load flex price results
load([dirPref 'RepAgent/results/experiment_0_FiscalAdj_' num2str(ID(2)) '_search_0_sticky_0_robustness_0.mat']);

iY = find(strcmp(Params.names,'Y'));

flexprice{1}.desc = char('flexible prices, complete markets');
flexprice{1}.shocks = shocks;
flexprice{1}.Y = simaggdat(:,iY);

clear Params shocks simaggdat;


load ../RepAgent/results/experiment_7_FiscalAdj_1_search_0_sticky_0_robustness_0.mat;

iY = find(strcmp(Params.names,'Y'));

flexprice{2}.desc = char('flexible prices, complete markets, no government');
flexprice{2}.shocks = shocks;
flexprice{2}.Y = simaggdat(:,iY);


assert(all(flexprice{1}.shocks(1,:) == flexprice{2}.shocks(1,:)));

clear Params shocks simaggdat;


% load experiment data

fname = [dirPref modelID dirSuf '/experiment_' num2str(ID(1)) '_FiscalAdj_' num2str(ID(2)) '_search_' num2str(ID(3))  '_sticky_' num2str(ID(4)) '_robustness_' num2str(ID(5)) '.mat'];
load(fname)

if strcmp(modelID,'RepAgent') || strcmp(modelID,'HandToMouth')
    if strcmp(modelID,'HandToMouth'), Params.names = Params.aggnames; end
    
    tmp = flexprice{1}.shocks(1:2,:) == shocks(1:2,:);
    assert(all( tmp(:) ));
    
    iY = find(strcmp(Params.names,'Y'));
    Y = simaggdat(:,iY);
    if strcmp(modelID,'HandToMouth')
        Hrs = simaggdat(:,strcmp(Params.names,'Hrs'));
    else
        Hrs = simaggdat(:,strcmp(Params.names,'N'));
    end
    C = simaggdat(:,strcmp(Params.names,'C'));
elseif strcmp(modelID,'FullModel')
%     if ID(3) == 1
         soln = exact_soln;
%     else
%         soln = MPA_soln;
%     end
    
    tmp = flexprice{1}.shocks(1:2,:) == soln.simshocks(1:2,:);
    assert(all( tmp(:) ));
    
    iY = find(strcmp(soln.names,'Y'));
    Y = soln.simaggdat(iY,:)';
    
    Hrs = soln.simaggdat(strcmp(soln.names,'Hrs'),:)';
    C = soln.simaggdat(strcmp(soln.names,'C'),:)';
    
end

ogaps = log(Y)*ones(1,2) - [log(flexprice{1}.Y) log(flexprice{2}.Y)];

mnogaps = mean(ogaps);
varogaps = var(ogaps);

%labor wedge
eps = 1/2;
cons  =  (1- 0.4)/mean(C./Y .*Hrs.^((1+eps)/eps));
Wedge = 1- cons * C./Y .*Hrs.^((1+eps)/eps);
lnWedge = log(Wedge);
VarLogLaborWedge = var(lnWedge);

end

