function [ dat ] = loadData( modelID, ID , varnames)

global dirPref dirSuf;

fname = [dirPref modelID dirSuf '/experiment_' num2str(ID(1)) '_FiscalAdj_' num2str(ID(2)) '_search_' num2str(ID(3))  '_sticky_' num2str(ID(4)) '_robustness_' num2str(ID(5)) '.mat'];
load(fname)

nvnms = length(varnames);

if strcmp(modelID, 'FullModel') || strcmp(modelID, 'FullModel_ISTC') || strcmp(modelID, 'FullModel_Payroll')
    dat = NaN(nvnms+3,2);  % + 3 is for 2 x output gap, indiv cons
    
    %     if ID(3) == 1
    soln = exact_soln;
    %     else
    %         soln = MPA_soln;
    %     end
    
    for i=1:nvnms
        inm = find(strcmp(soln.names,varnames(i)));
        if ~isempty(inm)
            dat(i,1) = soln.V0(inm,inm);
            dat(i,2) = soln.simul_avg(inm);
            
            %convert variance to variance of log
            dat(i,1) = dat(i,1)/(dat(i,2)^2);
        end
    end
    

elseif strcmp(modelID, 'RepAgent') || strcmp(modelID, 'HandToMouth')
    
    if strcmp(modelID, 'HandToMouth')
        Params.names = Params.aggnames;
    end
    
    %rename N to Hrs if Hrs does not exist
    if ~any(strcmp(Params.names,'Hrs'))
        iN = strcmp(Params.names,'N');
        Params.names{iN} = 'Hrs';
    end
    
    dat = NaN(nvnms+2,2);  % + 2 is for 2 x output gap
    
    for i=1:nvnms
        inm = find(strcmp(Params.names,varnames(i)));
        dat(i,1) = V0(inm,inm);
        dat(i,2) = simul_avg(inm);
        
        %convert variance to variance of log
        dat(i,1) = dat(i,1)/(dat(i,2)^2);
    end
    
    %output gap
    %[ mnogaps, varogaps , VarLogLaborWedge] = getoutputgaps( modelID, ID );
    %dat(nvnms+1:nvnms+2,1) = varogaps';
    %dat(nvnms+1:nvnms+2,2) = mnogaps';
    %dat(nvnms+3,1) = VarLogLaborWedge;
    
end

