function  str  = table2latex( T, caption, numdigits )


if ~exist('numdigits','var')
    numdigits = 3;
end
FORMAT = ['%0.' num2str(numdigits) 'f'];

Vars = T.Properties.VariableNames;
ncol = length(Vars);
nrow = length(getfield(T,Vars{1}));

if exist('caption','var')
    str = [caption '\\\\'];
else
    str = [];
end
str = [str '  \\begin{tabular}{' repmat('c', 1, ncol) '} \\toprule '];
for i = 1:ncol
    str = [str Vars{i}];
    if i < ncol
        str = [str  ' & '];
    else
        str = [str ' \\\\ '];
    end
end
str = [str '\\midrule  '];
for j = 1:nrow
    for i = 1:ncol
        x = getfield(T,Vars{i});
        str = [str num2str(x(j),FORMAT) ];
        if i < ncol
            str = [str  ' & '];
        else
            str = [str ' \\\\ '];
        end
    end
end
str = [str '\\bottomrule \\end{tabular}'];
