function welfare_driver(baselineID,experID,caption)

    %open file for writing
    fname = ['welfare_results/experiment_' num2str(experID(1)) ...
        '_FiscalAdj_' num2str(experID(2)) ...
        '_search_' num2str(experID(3))  ...
        '_sticky_' num2str(experID(4)) ...
        '_robustness_' num2str(experID(5)) '.tex'];
    
    fid= fopen(fname,'w');
    wr = @(str)(fprintf(fid,'%s\n',str));
    
    
    %print the header
    wr('\documentclass[letterpaper,notitlepage,12pt,letterpaper]{article} \usepackage{fullpage}  \usepackage{booktabs,caption,fixltx2e} \begin{document}');

    
    if exist('caption','var')
        wr(caption);
        wr(' ');
    end

    %do welfare for steady state
    [util_stst, betah] = DoWelfareForSteadyStateOrShocks(baselineID,experID,true,fid);
    wr(' ');
    
    %do welfare with shocks
    util = DoWelfareForSteadyStateOrShocks(baselineID,experID,false,fid);
    wr(' ');
    
    %calculate the welfare cost of cycles
    welfareCostOfCycles(util_stst, util, betah,fid);
    wr(' ');
    wr('\end{document}');
    fclose(fid);
    
end
function [utilitarian, betah] = DoWelfareForSteadyStateOrShocks(baselineID,experID,stst,fid)

wr = @(str)(fprintf(fid,'%s\n',str));



[dwe, iwTable, waTable, utilitarian,betah] = dwelfare( baselineID, experID , stst);







if stst
    wr('steady state');
else
    wr('with shocks');
end
wr(' ');

wr(['baselineID = ' num2str(baselineID)]);
wr(' ');
wr(['experimentID = ' num2str(experID)]);
wr(' ');
wr(['change in patient welfare = ' num2str(dwe) ]);
wr(' ');


wr(table2latex( iwTable, 'welfare for selected individuals') );
wr(' ');

wr(table2latex( waTable, 'welfare averaged across wealth') );
wr(' ');

wr(table2latex( utilitarian, 'utilitarian') );
wr(' ');


end



function welfareCostOfCycles(util_stst,util,betah,fid)

wcbc_before = exp((1-betah)*(util_stst.AvgUtilsBefore-util.AvgUtilsBefore))-1;
wcbc_after = exp((1-betah)*(util_stst.AvgUtilsAfter-util.AvgUtilsAfter))-1;

T = table([1:2]',wcbc_before,wcbc_after,wcbc_after./wcbc_before,'VariableNames',{'AvgOpt','Before','After','Ratio'});



wr = @(str)(fprintf(fid,'%s\n',str));

wr(table2latex( T, 'Welfaore cost of business cycles') );
wr(' ');

end
