clear all
close all
clc

%% Set parameters


Params.SigmaEpsz = 0.002936169743355;  % st dev of z shock
Params.rhoz = 0.75; % persistence of z shock

Params.SigmaG = 0;
Params.rhoG = 0;

Params.Sigmatax = 0;
Params.rhotax = 0;

Params.SigmaEpsmp = 0.003533607840688; % st dev of MP shock
Params.rhomp = 0.62; % persistence


Params.Sigmamarkup =  0.025141071226995;
Params.rhomarkup = 0.85;

Params.phiLST =  -1.6;  % fiscal adjustment speed parameter
Params.phiG = 0.8*Params.phiLST;


Params.phiP = 1.55;
Params.phiY = 0.0;
Params.phii = 0.0;

Params.Psi =  6;   %capital adj cost

Params.shockWeight =  [ 0.639337048621449  0.317676504487140];

T = 250;

l = {'zstar', 'betashockstar', 'mpshockstar', 'markupshockstar', 'laborMarketStatusstar'};

%%  Shock to z


zstar = ones(T,1);
betashockstar = ones(T,1);
mpshockstar = zeros(T,1);
markupshockstar = zeros(T,1);

zstar(2) = exp(-2 * Params.SigmaEpsz);

for t= 3:T
    zstar(t) = exp( Params.rhoz*log(zstar(t-1)) );
end

laborMarketStatusstar = Params.shockWeight(1) * log(zstar) - Params.shockWeight(2)*mpshockstar - (1-sum(Params.shockWeight))*markupshockstar;

save('Exog_z.mat',l{:});

f1 = figure;
for i = 1:length(l)
    subplot(3,2,i)
    eval(['plot(' l{i} ')'])
    title(l{i})
end

% Create textbox
annotation(f1,'textbox', [0.6 0.16 0.13 0.12],...
    'String',{'shock to z'},'FitBoxToText','off');


%%  Shock to mpshock


zstar = ones(T,1);
betashockstar = ones(T,1);
mpshockstar = zeros(T,1);
markupshockstar = zeros(T,1);

mpshockstar(2) = 2 * Params.SigmaEpsmp;

for t= 3:T
    mpshockstar(t) =  Params.rhomp * mpshockstar(t-1);
end

laborMarketStatusstar = Params.shockWeight(1) * log(zstar) - Params.shockWeight(2)*mpshockstar - (1-sum(Params.shockWeight))*markupshockstar;

save('Exog_mp.mat',l{:});

f1 = figure;
for i = 1:length(l)
    subplot(3,2,i)
    eval(['plot(' l{i} ')'])
    title(l{i})
end

annotation(f1,'textbox', [0.6 0.16 0.13 0.12],...
    'String',{'shock to mp'},'FitBoxToText','off');


%%  Shock to markupshock


zstar = ones(T,1);
betashockstar = ones(T,1);
mpshockstar = zeros(T,1);
markupshockstar = zeros(T,1);

markupshockstar(2) = 2 * Params.Sigmamarkup;

for t= 3:T
    markupshockstar(t) =  Params.rhomarkup * markupshockstar(t-1);
end

laborMarketStatusstar = Params.shockWeight(1) * log(zstar) - Params.shockWeight(2)*mpshockstar - (1-sum(Params.shockWeight))*markupshockstar;

save('Exog_markup.mat',l{:});

f1 = figure;
for i = 1:length(l)
    subplot(3,2,i)
    eval(['plot(' l{i} ')'])
    title(l{i})
end

annotation(f1,'textbox', [0.6 0.16 0.13 0.12],...
    'String',{'shock to markup'},'FitBoxToText','off');