function createDynareInputMat(modFilePath,fname_out,LengthOfTransition)



%Read in the mod file
filedata = fileread(modFilePath);
fileread_info.newline = regexp(filedata, '\n');
fileread_info.calibration = regexp(filedata, 'Calibration');
fileread_info.model = regexp(filedata, 'Model');

fileread_info.initval = regexp(filedata, 'initval;');  %semi-colon inside quotes is important b/c there should only be one such occurence
fileread_info.end = regexp(filedata, 'end;');
%replace all ends with the first one after initval
fileread_info.end = fileread_info.end(fileread_info.end>fileread_info.initval);
fileread_info.end = fileread_info.end(1);

calibration = fileread_info.newline > fileread_info.calibration &   fileread_info.newline < fileread_info.model; 
calibration = fileread_info.newline(calibration);
for iline = 1:length(calibration)-1
    try
        eval(filedata(calibration(iline)+1:calibration(iline+1)-1));
    catch
        disp(['skipped line: ''' filedata(calibration(iline)+1:calibration(iline+1)-1) ' '' '])
    end
end


steadystate = fileread_info.newline > fileread_info.initval &   fileread_info.newline < fileread_info.end; 
steadystate = fileread_info.newline(steadystate);
varnames = {};
for iline = 1:length(steadystate)-1
    line_data = filedata(steadystate(iline)+1:steadystate(iline+1)-1);
    try
        eval(line_data);
        line_data = strtrim(line_data(1:strfind(line_data,'=')-1));
        varnames = [varnames line_data];
    catch
        disp(['skipped line: ''' line_data(1:end-1) ' '' '])
    end
    
end

for iline = 1:length(varnames)
    eval([varnames{iline} ' = ' varnames{iline} ' * ones(' num2str(LengthOfTransition) ',1);']);
end

save(fname_out,varnames{:})


end