close all

%vars = {'C', 'N', 'Y', 'ii', 'ch','ce', 'E', 'ppi', 'wage'};
%varstr = {'C', 'Effective Labor', 'Y', 'i', 'impatient cons.', 'patient cons.', 'Empl.','inflation','wage'}

vars = { 'Y', 'C', 'ii', 'ch'};
varstr = {'Aggregate output', 'Aggregate consumption',  'Nominal interest', 'Impatient consumption'};


load ZLB_exp0_final;
%load ZLB_exp0_NoConstraint_final;
for iv = 1:length(vars)
    eval([vars{iv} '0 = ' vars{iv} '(2:16)/' vars{iv} '(end);'])
end

load ZLB_exp1_final;
%load ZLB_exp1_NoConstraint_final;
for iv = 1:length(vars)
    eval([vars{iv} '1 = ' vars{iv} '(2:16)/' vars{iv} '(end);'])
end


figure('Position', [200 200 600 600])

for iv = 1:length(vars)
    subplot(ceil(length(vars)/2),2,iv,'FontSize',14);
    hold on;
    
    
    eval(['dat0 = ' vars{iv} '0;']);
    eval(['dat1 = ' vars{iv} '1;']);
    
    if ~strcmp(vars{iv} , 'ii')
        dat0 = 100 * (dat0-1);
        dat1 = 100 * (dat1-1);
    end
    
    plot(dat0, 'color', 'k' , 'LineWidth', 2);
    plot(dat1, 'color', 'k' , 'LineWidth', 2, 'LineStyle', '--');
    
    
    xlim([-1 16])
    title(varstr{iv},'FontSize',14)
    box on
    
    if iv == 4
        legend('With stabilizers', 'Without stabilizers', 'Location','Best');
    end
    
    if iv >= length(vars)-1
        xlabel('Quarter')
    end
    
    if mod(iv,2) == 1
        ylabel('Percentage points')
    end
end
